/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.netty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testifyproject.apache.commons.lang.StringUtils;
import org.testifyproject.github.dockerjava.netty.ChannelProvider;
import org.testifyproject.github.dockerjava.netty.InvocationBuilder;

public class WebTarget {
    private ChannelProvider channelProvider;
    private List<String> path = new ArrayList<String>();
    private Map<String, String> queryParams = new HashMap<String, String>();
    private static final String PATH_SEPARATOR = "/";

    public WebTarget(ChannelProvider channelProvider) {
        this.channelProvider = channelProvider;
    }

    public WebTarget path(String ... components) {
        for (String component : components) {
            this.path.addAll(Arrays.asList(StringUtils.split(component, PATH_SEPARATOR)));
        }
        return this;
    }

    public InvocationBuilder request() {
        String resource = PATH_SEPARATOR + StringUtils.join(this.path, PATH_SEPARATOR);
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
            params.add(entry.getKey() + "=" + entry.getValue());
        }
        if (!params.isEmpty()) {
            resource = resource + "?" + StringUtils.join(params, "&");
        }
        return new InvocationBuilder(this.channelProvider, resource);
    }

    public WebTarget resolveTemplate(String name, Object value) {
        ArrayList<String> newPath = new ArrayList<String>();
        for (String component : this.path) {
            component = component.replaceAll("\\{" + name + "\\}", value.toString());
            newPath.add(component);
        }
        this.path = newPath;
        return this;
    }

    public WebTarget queryParam(String name, Object value) {
        if (value != null) {
            this.queryParams.put(name, value.toString());
        }
        return this;
    }
}

