/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.netty.handler;

import java.io.Closeable;
import java.nio.charset.Charset;
import org.testifyproject.github.dockerjava.api.async.ResultCallback;
import org.testifyproject.github.dockerjava.api.exception.BadRequestException;
import org.testifyproject.github.dockerjava.api.exception.ConflictException;
import org.testifyproject.github.dockerjava.api.exception.DockerException;
import org.testifyproject.github.dockerjava.api.exception.InternalServerErrorException;
import org.testifyproject.github.dockerjava.api.exception.NotAcceptableException;
import org.testifyproject.github.dockerjava.api.exception.NotFoundException;
import org.testifyproject.github.dockerjava.api.exception.NotModifiedException;
import org.testifyproject.github.dockerjava.api.exception.UnauthorizedException;
import org.testifyproject.github.dockerjava.netty.handler.HttpRequestProvider;
import org.testifyproject.netty.buffer.ByteBuf;
import org.testifyproject.netty.buffer.Unpooled;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.channel.SimpleChannelInboundHandler;
import org.testifyproject.netty.handler.codec.http.HttpContent;
import org.testifyproject.netty.handler.codec.http.HttpHeaderNames;
import org.testifyproject.netty.handler.codec.http.HttpObject;
import org.testifyproject.netty.handler.codec.http.HttpRequest;
import org.testifyproject.netty.handler.codec.http.HttpResponse;
import org.testifyproject.netty.handler.codec.http.LastHttpContent;

public class HttpResponseHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private HttpResponse response;
    private ByteBuf errorBody = Unpooled.buffer();
    private HttpRequestProvider requestProvider;
    private ResultCallback<?> resultCallback;

    public HttpResponseHandler(HttpRequestProvider requestProvider, ResultCallback<?> resultCallback) {
        super(false);
        this.requestProvider = requestProvider;
        this.resultCallback = resultCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void channelRead0(final ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpResponse) {
            this.response = (HttpResponse)msg;
            this.resultCallback.onStart(new Closeable(){

                @Override
                public void close() {
                    ctx.channel().close();
                }
            });
            return;
        }
        if (!(msg instanceof HttpContent)) return;
        HttpContent content = (HttpContent)msg;
        ByteBuf byteBuf = content.content();
        switch (this.response.status().code()) {
            case 200: 
            case 201: 
            case 204: {
                ctx.fireChannelRead(byteBuf);
                break;
            }
            default: {
                this.errorBody.writeBytes(byteBuf);
            }
        }
        if (!(content instanceof LastHttpContent)) return;
        try {
            switch (this.response.status().code()) {
                case 101: 
                case 200: 
                case 201: 
                case 204: {
                    return;
                }
                case 301: 
                case 302: {
                    if (!this.response.headers().contains(HttpHeaderNames.LOCATION)) return;
                    String location = this.response.headers().get(HttpHeaderNames.LOCATION);
                    HttpRequest redirected = this.requestProvider.getHttpRequest(location);
                    ctx.channel().writeAndFlush(redirected);
                    return;
                }
                case 304: {
                    throw new NotModifiedException(this.getBodyAsMessage(this.errorBody));
                }
                case 400: {
                    throw new BadRequestException(this.getBodyAsMessage(this.errorBody));
                }
                case 401: {
                    throw new UnauthorizedException(this.getBodyAsMessage(this.errorBody));
                }
                case 404: {
                    throw new NotFoundException(this.getBodyAsMessage(this.errorBody));
                }
                case 406: {
                    throw new NotAcceptableException(this.getBodyAsMessage(this.errorBody));
                }
                case 409: {
                    throw new ConflictException(this.getBodyAsMessage(this.errorBody));
                }
                case 500: {
                    throw new InternalServerErrorException(this.getBodyAsMessage(this.errorBody));
                }
                default: {
                    throw new DockerException(this.getBodyAsMessage(this.errorBody), this.response.status().code());
                }
            }
        }
        catch (Throwable e) {
            this.resultCallback.onError(e);
            return;
        }
        finally {
            this.resultCallback.onComplete();
        }
    }

    private String getBodyAsMessage(ByteBuf body) {
        String result = body.readBytes(body.readableBytes()).toString(Charset.forName("UTF-8"));
        body.discardReadBytes();
        body.release();
        return result;
    }
}

