/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.netty.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testifyproject.github.dockerjava.api.async.ResultCallback;
import org.testifyproject.netty.buffer.ByteBuf;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.channel.SimpleChannelInboundHandler;

public class HttpResponseStreamHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private HttpResponseInputStream stream = new HttpResponseInputStream();

    public HttpResponseStreamHandler(ResultCallback<InputStream> resultCallback) {
        resultCallback.onNext(this.stream);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        this.stream.write(msg.copy());
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.stream.close();
        super.channelReadComplete(ctx);
    }

    public static class HttpResponseInputStream
    extends InputStream {
        private AtomicBoolean closed = new AtomicBoolean(false);
        private LinkedTransferQueue<ByteBuf> queue = new LinkedTransferQueue();
        private ByteBuf current = null;

        public void write(ByteBuf byteBuf) {
            this.queue.put(byteBuf);
        }

        @Override
        public void close() throws IOException {
            this.closed.set(true);
            super.close();
        }

        @Override
        public int available() throws IOException {
            this.poll();
            return this.readableBytes();
        }

        private int readableBytes() {
            if (this.current != null) {
                return this.current.readableBytes();
            }
            return 0;
        }

        @Override
        public int read() throws IOException {
            this.poll();
            if (this.readableBytes() == 0 && this.closed.get()) {
                return -1;
            }
            if (this.current != null && this.current.readableBytes() > 0) {
                return this.current.readByte() & 0xFF;
            }
            return this.read();
        }

        private void poll() {
            if (this.readableBytes() == 0) {
                try {
                    this.current = this.queue.poll(50L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

