/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.github.dockerjava.netty.handler;

import org.testifyproject.fasterxml.jackson.core.type.TypeReference;
import org.testifyproject.fasterxml.jackson.databind.ObjectMapper;
import org.testifyproject.github.dockerjava.api.async.ResultCallback;
import org.testifyproject.netty.buffer.ByteBuf;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.channel.SimpleChannelInboundHandler;

public class JsonResponseCallbackHandler<T>
extends SimpleChannelInboundHandler<ByteBuf> {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private TypeReference<T> typeReference;
    private ResultCallback<T> callback;

    public JsonResponseCallbackHandler(TypeReference<T> typeReference, ResultCallback<T> callback) {
        this.typeReference = typeReference;
        this.callback = callback;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        byte[] buffer = new byte[msg.readableBytes()];
        msg.readBytes(buffer);
        msg.discardReadBytes();
        Object object = null;
        try {
            object = objectMapper.readValue(buffer, this.typeReference);
        }
        catch (Exception e) {
            this.callback.onError(e);
            throw new RuntimeException(e);
        }
        this.callback.onNext(object);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.callback.onError(cause);
        ctx.close();
    }
}

