/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.glassfish.hk2.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.testifyproject.glassfish.hk2.api.DescriptorFileFinder;

public class ClasspathDescriptorFileFinder
implements DescriptorFileFinder {
    private static final String DEFAULT_NAME = "org.testifyprojectfault";
    private final ClassLoader classLoader;
    private final String name;

    public ClasspathDescriptorFileFinder() {
        this(ClasspathDescriptorFileFinder.class.getClassLoader());
    }

    public ClasspathDescriptorFileFinder(ClassLoader cl) {
        this(cl, DEFAULT_NAME);
    }

    public ClasspathDescriptorFileFinder(ClassLoader cl, String name) {
        this.classLoader = cl;
        this.name = name;
    }

    @Override
    public List<InputStream> findDescriptorFiles() throws IOException {
        ArrayList<InputStream> returnList = new ArrayList<InputStream>();
        Enumeration<URL> e = this.classLoader.getResources("META-INF/hk2-locator/" + this.name);
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            returnList.add(url.openStream());
        }
        return returnList;
    }

    public String toString() {
        return "ClasspathDescriptorFileFinder(" + this.classLoader + "," + this.name + "," + System.identityHashCode(this) + ")";
    }
}

