/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.jvnet.hk2.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import org.testifyproject.aopalliance.intercept.ConstructorInterceptor;
import org.testifyproject.aopalliance.intercept.ConstructorInvocation;
import org.testifyproject.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.testifyproject.jvnet.hk2.internal.ConstructorAction;

public class ConstructorInterceptorHandler {
    private static final ConstructorAction DEFAULT_ACTION = new ConstructorAction(){

        @Override
        public Object makeMe(Constructor<?> c, Object[] args, boolean neutralCCL) throws Throwable {
            return ReflectionHelper.makeMe(c, args, neutralCCL);
        }
    };

    public static Object construct(Constructor<?> c, Object[] args, boolean neutralCCL, List<ConstructorInterceptor> interceptors, ConstructorAction action) throws Throwable {
        ConstructorInterceptor firstInterceptor;
        Object retVal;
        if (interceptors == null || interceptors.isEmpty()) {
            return action.makeMe(c, args, neutralCCL);
        }
        if (!(interceptors instanceof RandomAccess)) {
            interceptors = new ArrayList<ConstructorInterceptor>(interceptors);
        }
        if ((retVal = (firstInterceptor = interceptors.get(0)).construct(new ConstructorInvocationImpl(c, args, neutralCCL, action, 0, interceptors))) == null) {
            throw new AssertionError((Object)("ConstructorInterceptor construct method returned null for " + c));
        }
        return retVal;
    }

    public static Object construct(Constructor<?> c, Object[] args, boolean neutralCCL, List<ConstructorInterceptor> interceptors) throws Throwable {
        return ConstructorInterceptorHandler.construct(c, args, neutralCCL, interceptors, DEFAULT_ACTION);
    }

    private static class ConstructorInvocationImpl
    implements ConstructorInvocation {
        private final Constructor<?> c;
        private final Object[] args;
        private final boolean neutralCCL;
        private Object myThis = null;
        private final int index;
        private final ConstructorAction finalAction;
        private final List<ConstructorInterceptor> interceptors;

        private ConstructorInvocationImpl(Constructor<?> c, Object[] args, boolean neutralCCL, ConstructorAction finalAction, int index, List<ConstructorInterceptor> interceptors) {
            this.c = c;
            this.args = args;
            this.neutralCCL = neutralCCL;
            this.finalAction = finalAction;
            this.index = index;
            this.interceptors = interceptors;
        }

        @Override
        public Object[] getArguments() {
            return this.args;
        }

        @Override
        public AccessibleObject getStaticPart() {
            return this.c;
        }

        @Override
        public Object getThis() {
            return this.myThis;
        }

        @Override
        public Object proceed() throws Throwable {
            int newIndex = this.index + 1;
            if (newIndex >= this.interceptors.size()) {
                this.myThis = this.finalAction.makeMe(this.c, this.args, this.neutralCCL);
                return this.myThis;
            }
            ConstructorInterceptor nextInterceptor = this.interceptors.get(newIndex);
            this.myThis = nextInterceptor.construct(new ConstructorInvocationImpl(this.c, this.args, this.neutralCCL, this.finalAction, newIndex, this.interceptors));
            return this.myThis;
        }

        @Override
        public Constructor getConstructor() {
            return this.c;
        }
    }
}

