/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.channel;

import java.net.SocketAddress;
import org.testifyproject.netty.buffer.ByteBufAllocator;
import org.testifyproject.netty.channel.Channel;
import org.testifyproject.netty.channel.ChannelFuture;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.channel.ChannelHandlerInvoker;
import org.testifyproject.netty.channel.ChannelPipeline;
import org.testifyproject.netty.channel.ChannelProgressivePromise;
import org.testifyproject.netty.channel.ChannelPromise;
import org.testifyproject.netty.channel.DefaultChannelPipeline;
import org.testifyproject.netty.channel.DefaultChannelProgressivePromise;
import org.testifyproject.netty.channel.DefaultChannelPromise;
import org.testifyproject.netty.channel.FailedChannelFuture;
import org.testifyproject.netty.channel.SucceededChannelFuture;
import org.testifyproject.netty.util.Attribute;
import org.testifyproject.netty.util.AttributeKey;
import org.testifyproject.netty.util.ResourceLeakHint;
import org.testifyproject.netty.util.concurrent.EventExecutor;
import org.testifyproject.netty.util.internal.StringUtil;

abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private final boolean inbound;
    private final boolean outbound;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private boolean handlerRemoved;
    final ChannelHandlerInvoker invoker;
    private ChannelFuture succeededFuture;
    volatile Runnable invokeChannelReadCompleteTask;
    volatile Runnable invokeReadTask;
    volatile Runnable invokeChannelWritableStateChangedTask;
    volatile Runnable invokeFlushTask;

    AbstractChannelHandlerContext(DefaultChannelPipeline pipeline, ChannelHandlerInvoker invoker, String name, boolean inbound, boolean outbound) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.pipeline = pipeline;
        this.name = name;
        this.invoker = invoker;
        this.inbound = inbound;
        this.outbound = outbound;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        return this.invoker().executor();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.channel().attr(key);
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.channel().hasAttr(key);
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelRegistered();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelUnregistered();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelActive();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelInactive();
        return this;
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        AbstractChannelHandlerContext next = this.next;
        next.invokeExceptionCaught(cause);
        return this;
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object event) {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeUserEventTriggered(event);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object msg) {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelRead(this.pipeline.touch(msg, next));
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelReadComplete();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext next = this.findContextInbound();
        next.invokeChannelWritabilityChanged();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeBind(localAddress, promise);
        return promise;
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.connect(remoteAddress, null, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeConnect(remoteAddress, localAddress, promise);
        return promise;
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(promise);
        }
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeDisconnect(promise);
        return promise;
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeClose(promise);
        return promise;
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeDeregister(promise);
        return promise;
    }

    @Override
    public ChannelHandlerContext read() {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeRead();
        return this;
    }

    @Override
    public ChannelFuture write(Object msg) {
        return this.write(msg, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object msg, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeWrite(this.pipeline.touch(msg, next), promise);
        return promise;
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeFlush();
        return this;
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        AbstractChannelHandlerContext next = this.findContextOutbound();
        next.invokeWriteAndFlush(this.pipeline.touch(msg, next), promise);
        return promise;
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture succeededFuture = this.succeededFuture;
        if (succeededFuture == null) {
            this.succeededFuture = succeededFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return succeededFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        return new FailedChannelFuture(this.channel(), this.executor(), cause);
    }

    private AbstractChannelHandlerContext findContextInbound() {
        AbstractChannelHandlerContext ctx = this;
        do {
            ctx = ctx.next;
        } while (!ctx.inbound);
        return ctx;
    }

    private AbstractChannelHandlerContext findContextOutbound() {
        AbstractChannelHandlerContext ctx = this;
        do {
            ctx = ctx.prev;
        } while (!ctx.outbound);
        return ctx;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    void setRemoved() {
        this.handlerRemoved = true;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerRemoved;
    }

    final void invokeChannelRegistered() {
        this.invoker().invokeChannelRegistered(this);
    }

    final void invokeChannelUnregistered() {
        this.invoker().invokeChannelUnregistered(this);
    }

    final void invokeChannelActive() {
        this.invoker().invokeChannelActive(this);
    }

    final void invokeChannelInactive() {
        this.invoker().invokeChannelInactive(this);
    }

    final void invokeExceptionCaught(Throwable cause) {
        this.invoker().invokeExceptionCaught(this, cause);
    }

    final void invokeUserEventTriggered(Object event) {
        this.invoker().invokeUserEventTriggered(this, event);
    }

    final void invokeChannelRead(Object msg) {
        this.invoker().invokeChannelRead(this, msg);
    }

    final void invokeChannelReadComplete() {
        this.invoker().invokeChannelReadComplete(this);
    }

    final void invokeChannelWritabilityChanged() {
        this.invoker().invokeChannelWritabilityChanged(this);
    }

    final void invokeBind(SocketAddress localAddress, ChannelPromise promise) {
        this.invoker().invokeBind(this, localAddress, promise);
    }

    final void invokeConnect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        this.invoker().invokeConnect(this, remoteAddress, localAddress, promise);
    }

    final void invokeDisconnect(ChannelPromise promise) {
        this.invoker().invokeDisconnect(this, promise);
    }

    final void invokeClose(ChannelPromise promise) {
        this.invoker().invokeClose(this, promise);
    }

    final void invokeDeregister(ChannelPromise promise) {
        this.invoker().invokeDeregister(this, promise);
    }

    final void invokeRead() {
        this.invoker().invokeRead(this);
    }

    final void invokeWrite(Object msg, ChannelPromise promise) {
        this.invoker().invokeWrite(this, msg, promise);
    }

    final void invokeFlush() {
        this.invoker().invokeFlush(this);
    }

    final void invokeWriteAndFlush(Object msg, ChannelPromise promise) {
        ChannelHandlerInvoker invoker = this.invoker();
        invoker.invokeWrite(this, msg, promise);
        invoker.invokeFlush(this);
    }

    @Override
    public ChannelHandlerInvoker invoker() {
        return this.invoker == null ? this.channel().unsafe().invoker() : this.invoker;
    }

    @Override
    public String toHintString() {
        return '\'' + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }
}

