/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.channel;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import org.testifyproject.netty.channel.Channel;
import org.testifyproject.netty.channel.ChannelFuture;
import org.testifyproject.netty.channel.ChannelPromise;
import org.testifyproject.netty.channel.EventLoop;
import org.testifyproject.netty.channel.EventLoopGroup;
import org.testifyproject.netty.util.concurrent.DefaultThreadFactory;
import org.testifyproject.netty.util.concurrent.MultithreadEventExecutorGroup;
import org.testifyproject.netty.util.internal.SystemPropertyUtil;
import org.testifyproject.netty.util.internal.logging.InternalLogger;
import org.testifyproject.netty.util.internal.logging.InternalLoggerFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("org.testifyproject.netty.eventLoopThreads", Runtime.getRuntime().availableProcessors() * 2));

    protected MultithreadEventLoopGroup(int nThreads, Executor executor, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, executor, args);
    }

    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, threadFactory, args);
    }

    @Override
    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    protected abstract EventLoop newChild(Executor var1, Object ... var2) throws Exception;

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

