/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.channel.epoll;

import java.net.SocketAddress;
import org.testifyproject.netty.channel.Channel;
import org.testifyproject.netty.channel.ChannelOutboundBuffer;
import org.testifyproject.netty.channel.ChannelPipeline;
import org.testifyproject.netty.channel.epoll.AbstractEpollChannel;
import org.testifyproject.netty.channel.epoll.AbstractEpollStreamChannel;
import org.testifyproject.netty.channel.epoll.EpollDomainSocketChannelConfig;
import org.testifyproject.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import org.testifyproject.netty.channel.epoll.Native;
import org.testifyproject.netty.channel.unix.DomainSocketAddress;
import org.testifyproject.netty.channel.unix.DomainSocketChannel;
import org.testifyproject.netty.channel.unix.FileDescriptor;
import org.testifyproject.netty.channel.unix.Socket;

public final class EpollDomainSocketChannel
extends AbstractEpollStreamChannel
implements DomainSocketChannel {
    private final EpollDomainSocketChannelConfig config = new EpollDomainSocketChannelConfig(this);
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;

    public EpollDomainSocketChannel() {
        super(Socket.newSocketDomain(), false);
    }

    @Deprecated
    public EpollDomainSocketChannel(Channel parent, FileDescriptor fd) {
        super(parent, new Socket(fd.intValue()));
    }

    @Deprecated
    public EpollDomainSocketChannel(FileDescriptor fd) {
        super(fd);
    }

    public EpollDomainSocketChannel(Channel parent, Socket fd) {
        super(parent, fd);
    }

    public EpollDomainSocketChannel(Socket fd, boolean active) {
        super(fd, active);
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDomainUnsafe();
    }

    @Override
    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.fd().bind(localAddress);
        this.local = (DomainSocketAddress)localAddress;
    }

    @Override
    public EpollDomainSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (super.doConnect(remoteAddress, localAddress)) {
            this.local = (DomainSocketAddress)localAddress;
            this.remote = (DomainSocketAddress)remoteAddress;
            return true;
        }
        return false;
    }

    @Override
    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    @Override
    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    @Override
    protected boolean doWriteSingle(ChannelOutboundBuffer in, int writeSpinCount) throws Exception {
        Object msg = in.current();
        if (msg instanceof FileDescriptor && Native.sendFd(this.fd().intValue(), ((FileDescriptor)msg).intValue()) > 0) {
            in.remove();
            return true;
        }
        return super.doWriteSingle(in, writeSpinCount);
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof FileDescriptor) {
            return msg;
        }
        return super.filterOutboundMessage(msg);
    }

    private final class EpollDomainUnsafe
    extends AbstractEpollStreamChannel.EpollStreamUnsafe {
        private EpollDomainUnsafe() {
            super(EpollDomainSocketChannel.this);
        }

        @Override
        void epollInReady() {
            switch (EpollDomainSocketChannel.this.config().getReadMode()) {
                case BYTES: {
                    super.epollInReady();
                    break;
                }
                case FILE_DESCRIPTORS: {
                    this.epollInReadFd();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void epollInReadFd() {
            if (EpollDomainSocketChannel.this.fd().isInputShutdown()) {
                return;
            }
            boolean edgeTriggered = EpollDomainSocketChannel.this.isFlagSet(Native.EPOLLET);
            EpollDomainSocketChannelConfig config = EpollDomainSocketChannel.this.config();
            if (!(this.readPending || edgeTriggered || config.isAutoRead())) {
                this.clearEpollIn0();
                return;
            }
            ChannelPipeline pipeline = EpollDomainSocketChannel.this.pipeline();
            EpollRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            allocHandle.reset(config);
            try {
                int socketFd;
                while ((socketFd = Native.recvFd(EpollDomainSocketChannel.this.fd().intValue())) != 0) {
                    if (socketFd == -1) {
                        this.close(this.voidPromise());
                        return;
                    }
                    this.readPending = false;
                    allocHandle.incMessagesRead(1);
                    pipeline.fireChannelRead(new FileDescriptor(socketFd));
                    if (allocHandle.continueReading()) continue;
                }
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
            }
            catch (Throwable t) {
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                pipeline.fireExceptionCaught(t);
                this.checkResetEpollIn(edgeTriggered);
            }
            finally {
                if (!this.readPending && !config.isAutoRead()) {
                    this.clearEpollIn0();
                }
            }
        }
    }
}

