/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.channel.epoll;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Locale;
import org.testifyproject.netty.channel.DefaultFileRegion;
import org.testifyproject.netty.channel.epoll.EpollEventArray;
import org.testifyproject.netty.channel.epoll.EpollTcpInfo;
import org.testifyproject.netty.channel.epoll.NativeDatagramPacketArray;
import org.testifyproject.netty.channel.epoll.NativeStaticallyReferencedJniMethods;
import org.testifyproject.netty.channel.unix.Errors;
import org.testifyproject.netty.channel.unix.FileDescriptor;
import org.testifyproject.netty.channel.unix.NativeInetAddress;
import org.testifyproject.netty.util.internal.NativeLibraryLoader;
import org.testifyproject.netty.util.internal.PlatformDependent;
import org.testifyproject.netty.util.internal.SystemPropertyUtil;

public final class Native {
    public static final int EPOLLIN;
    public static final int EPOLLOUT;
    public static final int EPOLLRDHUP;
    public static final int EPOLLET;
    public static final int EPOLLERR;
    public static final int IOV_MAX;
    public static final int UIO_MAX_IOV;
    public static final boolean IS_SUPPORTING_SENDMMSG;
    public static final boolean IS_SUPPORTING_TCP_FASTOPEN;
    public static final long SSIZE_MAX;
    public static final int TCP_MD5SIG_MAXKEYLEN;
    public static final String KERNEL_VERSION;
    private static final Errors.NativeIoException CONNECTION_RESET_EXCEPTION_SENDFILE;
    private static final Errors.NativeIoException CONNECTION_RESET_EXCEPTION_SENDMMSG;
    private static final Errors.NativeIoException CONNECTION_RESET_EXCEPTION_SPLICE;

    public static FileDescriptor newEventFd() {
        return new FileDescriptor(Native.eventFd());
    }

    private static native int eventFd();

    public static native void eventFdWrite(int var0, long var1);

    public static native void eventFdRead(int var0);

    public static FileDescriptor newEpollCreate() {
        return new FileDescriptor(Native.epollCreate());
    }

    private static native int epollCreate();

    public static int epollWait(int efd, EpollEventArray events, int timeout) throws IOException {
        int ready = Native.epollWait0(efd, events.memoryAddress(), events.length(), timeout);
        if (ready < 0) {
            throw Errors.newIOException("epoll_wait", ready);
        }
        return ready;
    }

    private static native int epollWait0(int var0, long var1, int var3, int var4);

    public static void epollCtlAdd(int efd, int fd, int flags) throws IOException {
        int res = Native.epollCtlAdd0(efd, fd, flags);
        if (res < 0) {
            throw Errors.newIOException("epoll_ctl", res);
        }
    }

    private static native int epollCtlAdd0(int var0, int var1, int var2);

    public static void epollCtlMod(int efd, int fd, int flags) throws IOException {
        int res = Native.epollCtlMod0(efd, fd, flags);
        if (res < 0) {
            throw Errors.newIOException("epoll_ctl", res);
        }
    }

    private static native int epollCtlMod0(int var0, int var1, int var2);

    public static void epollCtlDel(int efd, int fd) throws IOException {
        int res = Native.epollCtlDel0(efd, fd);
        if (res < 0) {
            throw Errors.newIOException("epoll_ctl", res);
        }
    }

    private static native int epollCtlDel0(int var0, int var1);

    public static int splice(int fd, long offIn, int fdOut, long offOut, long len) throws IOException {
        int res = Native.splice0(fd, offIn, fdOut, offOut, len);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("splice", res, CONNECTION_RESET_EXCEPTION_SPLICE);
    }

    private static native int splice0(int var0, long var1, int var3, long var4, long var6);

    public static long sendfile(int dest, DefaultFileRegion src, long baseOffset, long offset, long length) throws IOException {
        src.open();
        long res = Native.sendfile0(dest, src, baseOffset, offset, length);
        if (res >= 0L) {
            return res;
        }
        return Errors.ioResult("sendfile", (int)res, CONNECTION_RESET_EXCEPTION_SENDFILE);
    }

    private static native long sendfile0(int var0, DefaultFileRegion var1, long var2, long var4, long var6) throws IOException;

    public static int sendmmsg(int fd, NativeDatagramPacketArray.NativeDatagramPacket[] msgs, int offset, int len) throws IOException {
        int res = Native.sendmmsg0(fd, msgs, offset, len);
        if (res >= 0) {
            return res;
        }
        return Errors.ioResult("sendmmsg", res, CONNECTION_RESET_EXCEPTION_SENDMMSG);
    }

    private static native int sendmmsg0(int var0, NativeDatagramPacketArray.NativeDatagramPacket[] var1, int var2, int var3);

    public static int recvFd(int fd) throws IOException {
        int res = Native.recvFd0(fd);
        if (res > 0) {
            return res;
        }
        if (res == 0) {
            return -1;
        }
        if (res == Errors.ERRNO_EAGAIN_NEGATIVE || res == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        throw Errors.newIOException("recvFd", res);
    }

    private static native int recvFd0(int var0);

    public static int sendFd(int socketFd, int fd) throws IOException {
        int res = Native.sendFd0(socketFd, fd);
        if (res >= 0) {
            return res;
        }
        if (res == Errors.ERRNO_EAGAIN_NEGATIVE || res == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("sendFd", res);
    }

    private static native int sendFd0(int var0, int var1);

    public static native int isReuseAddress(int var0);

    public static native int isReusePort(int var0);

    public static native int getTcpNotSentLowAt(int var0);

    public static native int getTrafficClass(int var0);

    public static native int isBroadcast(int var0);

    public static native int getTcpKeepIdle(int var0);

    public static native int getTcpKeepIntvl(int var0);

    public static native int getTcpKeepCnt(int var0);

    public static native int getTcpUserTimeout(int var0);

    public static native int isIpFreeBind(int var0);

    public static native void setReuseAddress(int var0, int var1);

    public static native void setReusePort(int var0, int var1);

    public static native void setTcpFastopen(int var0, int var1);

    public static native void setTcpNotSentLowAt(int var0, int var1);

    public static native void setTrafficClass(int var0, int var1);

    public static native void setBroadcast(int var0, int var1);

    public static native void setTcpKeepIdle(int var0, int var1);

    public static native void setTcpKeepIntvl(int var0, int var1);

    public static native void setTcpKeepCnt(int var0, int var1);

    public static native void setTcpUserTimeout(int var0, int var1);

    public static native void setIpFreeBind(int var0, int var1);

    public static void tcpInfo(int fd, EpollTcpInfo info) {
        Native.tcpInfo0(fd, info.info);
    }

    private static native void tcpInfo0(int var0, int[] var1);

    public static void setTcpMd5Sig(int fd, InetAddress address, byte[] key) {
        NativeInetAddress a = NativeInetAddress.newInstance(address);
        Native.setTcpMd5Sig0(fd, a.address(), a.scopeId(), key);
    }

    private static native void setTcpMd5Sig0(int var0, byte[] var1, int var2, byte[] var3);

    public static native int sizeofEpollEvent();

    public static native int offsetofEpollData();

    private Native() {
    }

    static {
        String name = SystemPropertyUtil.get("os.name").toLowerCase(Locale.UK).trim();
        if (!name.startsWith("linux")) {
            throw new IllegalStateException("Only supported on Linux");
        }
        NativeLibraryLoader.load(SystemPropertyUtil.get("org.testifyproject.netty.packagePrefix", "").replace('.', '-') + "netty-transport-native-epoll", PlatformDependent.getClassLoader(Native.class));
        EPOLLIN = NativeStaticallyReferencedJniMethods.epollin();
        EPOLLOUT = NativeStaticallyReferencedJniMethods.epollout();
        EPOLLRDHUP = NativeStaticallyReferencedJniMethods.epollrdhup();
        EPOLLET = NativeStaticallyReferencedJniMethods.epollet();
        EPOLLERR = NativeStaticallyReferencedJniMethods.epollerr();
        IOV_MAX = NativeStaticallyReferencedJniMethods.iovMax();
        UIO_MAX_IOV = NativeStaticallyReferencedJniMethods.uioMaxIov();
        IS_SUPPORTING_SENDMMSG = NativeStaticallyReferencedJniMethods.isSupportingSendmmsg();
        IS_SUPPORTING_TCP_FASTOPEN = NativeStaticallyReferencedJniMethods.isSupportingTcpFastopen();
        SSIZE_MAX = NativeStaticallyReferencedJniMethods.ssizeMax();
        TCP_MD5SIG_MAXKEYLEN = NativeStaticallyReferencedJniMethods.tcpMd5SigMaxKeyLen();
        KERNEL_VERSION = NativeStaticallyReferencedJniMethods.kernelVersion();
        CONNECTION_RESET_EXCEPTION_SENDFILE = Errors.newConnectionResetException("syscall:sendfile(...)", Errors.ERRNO_EPIPE_NEGATIVE);
        CONNECTION_RESET_EXCEPTION_SENDMMSG = Errors.newConnectionResetException("syscall:sendmmsg(...)", Errors.ERRNO_EPIPE_NEGATIVE);
        CONNECTION_RESET_EXCEPTION_SPLICE = Errors.newConnectionResetException("syscall:splice(...)", Errors.ERRNO_EPIPE_NEGATIVE);
    }
}

