/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.handler.codec.base64;

import java.util.List;
import org.testifyproject.netty.buffer.ByteBuf;
import org.testifyproject.netty.channel.ChannelHandler;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.handler.codec.MessageToMessageDecoder;
import org.testifyproject.netty.handler.codec.base64.Base64;
import org.testifyproject.netty.handler.codec.base64.Base64Dialect;

@ChannelHandler.Sharable
public class Base64Decoder
extends MessageToMessageDecoder<ByteBuf> {
    private final Base64Dialect dialect;

    public Base64Decoder() {
        this(Base64Dialect.STANDARD);
    }

    public Base64Decoder(Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.dialect = dialect;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.decode(msg, msg.readerIndex(), msg.readableBytes(), this.dialect));
    }
}

