/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.netty.handler.codec.marshalling;

import org.testifyproject.jboss.marshalling.MarshallerFactory;
import org.testifyproject.jboss.marshalling.MarshallingConfiguration;
import org.testifyproject.jboss.marshalling.Unmarshaller;
import org.testifyproject.netty.channel.ChannelHandlerContext;
import org.testifyproject.netty.handler.codec.marshalling.UnmarshallerProvider;
import org.testifyproject.netty.util.concurrent.FastThreadLocal;

public class ThreadLocalUnmarshallerProvider
implements UnmarshallerProvider {
    private final FastThreadLocal<Unmarshaller> unmarshallers = new FastThreadLocal();
    private final MarshallerFactory factory;
    private final MarshallingConfiguration config;

    public ThreadLocalUnmarshallerProvider(MarshallerFactory factory, MarshallingConfiguration config) {
        this.factory = factory;
        this.config = config;
    }

    @Override
    public Unmarshaller getUnmarshaller(ChannelHandlerContext ctx) throws Exception {
        Unmarshaller unmarshaller = this.unmarshallers.get();
        if (unmarshaller == null) {
            unmarshaller = this.factory.createUnmarshaller(this.config);
            this.unmarshallers.set(unmarshaller);
        }
        return unmarshaller;
    }
}

