/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import org.testifyproject.newsclub.net.unix.AFUNIXSocketAddress;
import org.testifyproject.newsclub.net.unix.AFUNIXSocketException;
import org.testifyproject.newsclub.net.unix.NativeUnixSocket;

class AFUNIXSocketImpl
extends SocketImpl {
    private static final int SHUT_RD = 0;
    private static final int SHUT_WR = 1;
    private static final int SHUT_RD_WR = 2;
    private String socketFile;
    private boolean closed = false;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closedInputStream = false;
    private boolean closedOutputStream = false;
    private final AFUNIXInputStream in = new AFUNIXInputStream();
    private final AFUNIXOutputStream out = new AFUNIXOutputStream();

    public AFUNIXSocketImpl() {
        this.fd = new FileDescriptor();
    }

    FileDescriptor getFD() {
        return this.fd;
    }

    protected void accept(SocketImpl s) throws IOException {
        AFUNIXSocketImpl si = (AFUNIXSocketImpl)s;
        NativeUnixSocket.accept(this.socketFile, this.fd, si.fd);
        si.socketFile = this.socketFile;
        si.connected = true;
    }

    protected int available() throws IOException {
        return NativeUnixSocket.available(this.fd);
    }

    protected void bind(SocketAddress addr) throws IOException {
        this.bind(0, addr);
    }

    protected void bind(int backlog, SocketAddress addr) throws IOException {
        if (!(addr instanceof AFUNIXSocketAddress)) {
            throw new SocketException("Cannot bind to this type of address: " + addr.getClass());
        }
        AFUNIXSocketAddress address = (AFUNIXSocketAddress)addr;
        this.socketFile = address.getSocketFile();
        NativeUnixSocket.bind(this.socketFile, this.fd, backlog);
        this.bound = true;
        this.localport = address.getPort();
    }

    protected void bind(InetAddress host, int port) throws IOException {
        throw new SocketException("Cannot bind to this type of address: " + InetAddress.class);
    }

    private void checkClose() throws IOException {
        if (!this.closedInputStream || this.closedOutputStream) {
            // empty if block
        }
    }

    protected synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.fd.valid()) {
            NativeUnixSocket.shutdown(this.fd, 2);
            NativeUnixSocket.close(this.fd);
        }
        if (this.bound) {
            NativeUnixSocket.unlink(this.socketFile);
        }
        this.connected = false;
    }

    protected void connect(String host, int port) throws IOException {
        throw new SocketException("Cannot bind to this type of address: " + InetAddress.class);
    }

    protected void connect(InetAddress address, int port) throws IOException {
        throw new SocketException("Cannot bind to this type of address: " + InetAddress.class);
    }

    protected void connect(SocketAddress addr, int timeout) throws IOException {
        if (!(addr instanceof AFUNIXSocketAddress)) {
            throw new SocketException("Cannot bind to this type of address: " + addr.getClass());
        }
        AFUNIXSocketAddress address = (AFUNIXSocketAddress)addr;
        this.socketFile = address.getSocketFile();
        NativeUnixSocket.connect(this.socketFile, this.fd);
        this.address = address.getAddress();
        this.port = address.getPort();
        this.localport = 0;
        this.connected = true;
    }

    protected void create(boolean stream) throws IOException {
    }

    protected InputStream getInputStream() throws IOException {
        if (!this.connected && !this.bound) {
            throw new IOException("Not connected/not bound");
        }
        return this.in;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (!this.connected && !this.bound) {
            throw new IOException("Not connected/not bound");
        }
        return this.out;
    }

    protected void listen(int backlog) throws IOException {
        NativeUnixSocket.listen(this.fd, backlog);
    }

    protected void sendUrgentData(int data) throws IOException {
        NativeUnixSocket.write(this.fd, new byte[]{(byte)(data & 0xFF)}, 0, 1);
    }

    public String toString() {
        return super.toString() + "[fd=" + this.fd + "; file=" + this.socketFile + "; connected=" + this.connected + "; bound=" + this.bound + "]";
    }

    private static int expectInteger(Object value) throws SocketException {
        int v;
        try {
            v = (Integer)value;
        }
        catch (ClassCastException e) {
            throw new AFUNIXSocketException("Unsupport value: " + value, e);
        }
        catch (NullPointerException e) {
            throw new AFUNIXSocketException("Value must not be null", e);
        }
        return v;
    }

    private static int expectBoolean(Object value) throws SocketException {
        int v;
        try {
            v = (Boolean)value != false ? 1 : 0;
        }
        catch (ClassCastException e) {
            throw new AFUNIXSocketException("Unsupport value: " + value, e);
        }
        catch (NullPointerException e) {
            throw new AFUNIXSocketException("Value must not be null", e);
        }
        return v;
    }

    public Object getOption(int optID) throws SocketException {
        try {
            switch (optID) {
                case 1: 
                case 8: {
                    return NativeUnixSocket.getSocketOptionInt(this.fd, optID) != 0;
                }
                case 128: 
                case 4097: 
                case 4098: 
                case 4102: {
                    return NativeUnixSocket.getSocketOptionInt(this.fd, optID);
                }
            }
        }
        catch (AFUNIXSocketException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AFUNIXSocketException("Error while getting option", e);
        }
        throw new AFUNIXSocketException("Unsupported option: " + optID);
    }

    public void setOption(int optID, Object value) throws SocketException {
        try {
            switch (optID) {
                case 128: {
                    if (value instanceof Boolean) {
                        boolean b = (Boolean)value;
                        if (b) {
                            throw new SocketException("Only accepting Boolean.FALSE here");
                        }
                        NativeUnixSocket.setSocketOptionInt(this.fd, optID, -1);
                        return;
                    }
                    NativeUnixSocket.setSocketOptionInt(this.fd, optID, AFUNIXSocketImpl.expectInteger(value));
                    return;
                }
                case 4097: 
                case 4098: 
                case 4102: {
                    NativeUnixSocket.setSocketOptionInt(this.fd, optID, AFUNIXSocketImpl.expectInteger(value));
                    return;
                }
                case 8: {
                    NativeUnixSocket.setSocketOptionInt(this.fd, optID, AFUNIXSocketImpl.expectBoolean(value));
                    return;
                }
                case 1: {
                    return;
                }
            }
        }
        catch (AFUNIXSocketException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AFUNIXSocketException("Error while setting option", e);
        }
        throw new AFUNIXSocketException("Unsupported option: " + optID);
    }

    protected void shutdownInput() throws IOException {
        if (!this.closed && this.fd.valid()) {
            NativeUnixSocket.shutdown(this.fd, 0);
        }
    }

    protected void shutdownOutput() throws IOException {
        if (!this.closed && this.fd.valid()) {
            NativeUnixSocket.shutdown(this.fd, 1);
        }
    }

    private final class AFUNIXOutputStream
    extends OutputStream {
        private boolean streamClosed = false;
        private byte[] buf1 = new byte[1];

        private AFUNIXOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            byte[] byArray = this.buf1;
            synchronized (this.buf1) {
                this.buf1[0] = (byte)b;
                this.write(this.buf1, 0, 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.streamClosed) {
                throw new AFUNIXSocketException("This OutputStream has already been closed.");
            }
            try {
                while (len > 0 && !Thread.interrupted()) {
                    int written = NativeUnixSocket.write(AFUNIXSocketImpl.this.fd, b, off, len);
                    if (written == -1) {
                        throw new IOException("Unspecific error while writing");
                    }
                    len -= written;
                    off += written;
                }
            }
            catch (IOException e) {
                throw (IOException)new IOException(e.getMessage() + " at " + AFUNIXSocketImpl.this.toString()).initCause(e);
            }
        }

        public void close() throws IOException {
            if (this.streamClosed) {
                return;
            }
            this.streamClosed = true;
            if (AFUNIXSocketImpl.this.fd.valid()) {
                NativeUnixSocket.shutdown(AFUNIXSocketImpl.this.fd, 1);
            }
            AFUNIXSocketImpl.this.closedOutputStream = true;
            AFUNIXSocketImpl.this.checkClose();
        }
    }

    private final class AFUNIXInputStream
    extends InputStream {
        private boolean streamClosed = false;
        private byte[] buf1 = new byte[1];

        private AFUNIXInputStream() {
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.streamClosed) {
                throw new IOException("This InputStream has already been closed.");
            }
            if (len == 0) {
                return 0;
            }
            try {
                return NativeUnixSocket.read(AFUNIXSocketImpl.this.fd, b, off, len);
            }
            catch (IOException e) {
                throw (IOException)new IOException(e.getMessage() + " at " + AFUNIXSocketImpl.this.toString()).initCause(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            byte[] byArray = this.buf1;
            synchronized (this.buf1) {
                int numRead = this.read(this.buf1, 0, 1);
                if (numRead <= 0) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return -1;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.buf1[0] & 0xFF;
            }
        }

        public void close() throws IOException {
            if (this.streamClosed) {
                return;
            }
            this.streamClosed = true;
            if (AFUNIXSocketImpl.this.fd.valid()) {
                NativeUnixSocket.shutdown(AFUNIXSocketImpl.this.fd, 0);
            }
            AFUNIXSocketImpl.this.closedInputStream = true;
            AFUNIXSocketImpl.this.checkClose();
        }

        public int available() throws IOException {
            int av = NativeUnixSocket.available(AFUNIXSocketImpl.this.fd);
            return av;
        }
    }
}

