/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.repackaged.com.google.common.collect;

import java.util.Map;
import org.testifyproject.repackaged.com.google.common.collect.ImmutableAsList;
import org.testifyproject.repackaged.com.google.common.collect.ImmutableCollection;
import org.testifyproject.repackaged.com.google.common.collect.ImmutableList;
import org.testifyproject.repackaged.com.google.common.collect.ImmutableMap;
import org.testifyproject.repackaged.com.google.common.collect.ImmutableSet;
import org.testifyproject.repackaged.com.google.common.collect.Maps;
import org.testifyproject.repackaged.com.google.common.collect.UnmodifiableIterator;

final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return Maps.valueIterator(((ImmutableSet)this.map.entrySet()).iterator());
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    ImmutableList<V> createAsList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<V>(){

            @Override
            public V get(int index) {
                return ((Map.Entry)entryList.get(index)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return ImmutableMapValues.this;
            }
        };
    }
}

