/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.exceptionhandler.test.testcase;

import junit.framework.TestCase;
import org.tinygroup.exceptionhandler.ExceptionHandler;
import org.tinygroup.exceptionhandler.ExceptionHandlerManager;
import org.tinygroup.exceptionhandler.impl.ExceptionHandlerManagerImpl;
import org.tinygroup.exceptionhandler.test.exception.Exception1;
import org.tinygroup.exceptionhandler.test.exception.Exception2;
import org.tinygroup.exceptionhandler.test.exception.Exception3;
import org.tinygroup.exceptionhandler.test.handler.Handler1;
import org.tinygroup.exceptionhandler.test.handler.Handler2;
import org.tinygroup.exceptionhandler.test.handler.Handler3;
import org.tinygroup.exceptionhandler.test.util.ResultUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerTest
extends TestCase {
    ExceptionHandlerManager manager;

    public void setUp() {
        this.manager = new ExceptionHandlerManagerImpl();
        this.addHandler("org.tinygroup.exceptionhandler.test.exception.Exception1", new Handler1());
        this.addHandler("org.tinygroup.exceptionhandler.test.exception.Exception2", new Handler2());
        this.addHandler("org.tinygroup.exceptionhandler.test.exception.Exception3", new Handler3());
    }

    private void addHandler(String excption, ExceptionHandler<?> handler) {
        try {
            this.manager.addHandler(excption, handler);
        }
        catch (ClassNotFoundException e) {
            System.out.println(String.format("\u6dfb\u52a0Handler\u65f6\u51fa\u73b0\u5f02\u5e38,Exception:%s\u672a\u627e\u5230", excption));
        }
    }

    public void testException1() {
        ResultUtil.clear();
        this.manager.handle((Throwable)((Object)new Exception1("e1")), null);
        ManagerTest.assertEquals((int)1, (int)ResultUtil.getResult());
    }

    public void testException2() {
        ResultUtil.clear();
        this.manager.handle((Throwable)((Object)new Exception2("e2")), null);
        ManagerTest.assertEquals((int)2, (int)ResultUtil.getResult());
    }

    public void testException3() {
        ResultUtil.clear();
        this.manager.handle((Throwable)((Object)new Exception3("e3")), null);
        ManagerTest.assertEquals((int)3, (int)ResultUtil.getResult());
    }

    public void testExceptionAll1() {
        ResultUtil.clear();
        this.manager.handleWithAllHandler((Throwable)((Object)new Exception1("e1")), null);
        ManagerTest.assertEquals((int)1, (int)ResultUtil.getResult());
    }

    public void testExceptionAll2() {
        ResultUtil.clear();
        this.manager.handleWithAllHandler((Throwable)((Object)new Exception2("e2")), null);
        ManagerTest.assertEquals((int)3, (int)ResultUtil.getResult());
    }

    public void testExceptionAll3() {
        ResultUtil.clear();
        this.manager.handleWithAllHandler((Throwable)((Object)new Exception3("e3")), null);
        ManagerTest.assertEquals((int)6, (int)ResultUtil.getResult());
    }
}

