/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowbasiccomponent.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.flowbasiccomponent.CommEnumConverter;
import org.tinygroup.flowbasiccomponent.exception.FlowComponentException;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.VFS;

public class CommEnumConverUntil {
    private static Logger LOGGER = LoggerFactory.getLogger(CommEnumConverUntil.class);
    private static Map<String, CommEnumConverter> commEnumConverts = new HashMap<String, CommEnumConverter>();
    private static Map<String, String> enumMap = new HashMap<String, String>();

    public static <T> T getEnum(String classPath, String value, String type) {
        CommEnumConverter converter = commEnumConverts.get(type);
        if (converter == null) {
            LOGGER.logMessage(LogLevel.ERROR, "\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u679a\u4e3e\u8f6c\u6362\u5668\uff1a{0}", new Object[]{type});
            throw new FlowComponentException("0TE120123013", type);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u679a\u4e3e\u7c7b\uff1a{0}", new Object[]{classPath});
            throw new FlowComponentException("0TE120123014", classPath);
        }
        if (!converter.isMatch(clazz)) {
            LOGGER.logMessage(LogLevel.ERROR, "\u6307\u5b9a\u7684\u679a\u4e3e\u8f6c\u6362\u7c7b\uff1a{0}\u4e0d\u652f\u6301\u679a\u4e3e\uff1a{1}\u7684\u8f6c\u6362", new Object[]{converter.getClass().getName(), classPath});
            throw new FlowComponentException("0TE120123015", converter.getClass().getName(), classPath);
        }
        return (T)converter.getEnum(value, clazz);
    }

    public static void readFile(String filePath) {
        Properties prop = new Properties();
        InputStream in = VFS.resolveFile((String)filePath).getInputStream();
        try {
            prop.load(in);
        }
        catch (IOException e) {
            LOGGER.logMessage(LogLevel.ERROR, "properties\u6587\u4ef6\uff1a{0}\u8bfb\u53d6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{filePath, e});
            throw new FlowComponentException("0TE120123020", filePath, e);
        }
        Set<Map.Entry<Object, Object>> set = prop.entrySet();
        Iterator<Map.Entry<Object, Object>> it = set.iterator();
        String key = null;
        String value = null;
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            key = String.valueOf(entry.getKey());
            value = String.valueOf(entry.getValue());
            key = key == null ? key : key.trim();
            value = value == null ? value : value.trim();
            enumMap.put(key, value);
        }
    }

    public static String codeConvert(String key) {
        if (enumMap.containsKey(key)) {
            return enumMap.get(key);
        }
        return enumMap.get("default_code");
    }

    static {
        Collection collection = BeanContainerFactory.getBeanContainer((ClassLoader)CommEnumConverUntil.class.getClassLoader()).getBeans(CommEnumConverter.class);
        for (CommEnumConverter convert : collection) {
            commEnumConverts.put(convert.getType(), convert);
        }
    }
}

