/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowbasiccomponent.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.flowbasiccomponent.DefaultFileFormat;
import org.tinygroup.flowbasiccomponent.FileFormat;
import org.tinygroup.flowbasiccomponent.exception.FlowComponentException;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;

public class FileUtil {
    public static final int BUFSIZE = 8192;
    private static Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);
    private static Map<String, FileFormat> fileFormats = new HashMap<String, FileFormat>();

    public static boolean existsFile(String filePath) {
        FileObject fileObject = VFS.resolveFile((String)filePath);
        return fileObject.isExist();
    }

    public static Object file2Object(String filePath, String classPath, String type) {
        try {
            FileFormat fileFormat;
            if (StringUtil.isBlank((String)filePath) || !FileUtil.existsFile(filePath)) {
                LOGGER.logMessage(LogLevel.ERROR, "\u6587\u4ef6\uff1a{0}\u4e0d\u5b58\u5728", new Object[]{filePath});
                throw new FlowComponentException("0TE120123007", filePath);
            }
            if (StringUtil.isBlank((String)type)) {
                type = DefaultFileFormat.TINY_FILE_FORMAT_TYPE;
            }
            if ((fileFormat = fileFormats.get(type)) == null) {
                LOGGER.logMessage(LogLevel.ERROR, "\u6587\u4ef6\u683c\u5f0f\u5316\u5de5\u5177\uff1a{0}\u672a\u627e\u5230", new Object[]{type});
                throw new FlowComponentException("0TE120123008", type);
            }
            return fileFormat.formatFile(filePath, classPath);
        }
        catch (FlowComponentException e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u6587\u4ef6\uff1a{0}\u8f6c\u5bf9\u8c61\u65f6\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{filePath, e});
            throw e;
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u6587\u4ef6\uff1a{0}\u8f6c\u5bf9\u8c61\u65f6\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{filePath, e});
            throw new FlowComponentException("0TE120123003", filePath, e);
        }
    }

    public static <T> void object2File(String filePath, T t, String type) {
        try {
            FileFormat fileFormat;
            if (StringUtil.isBlank((String)type)) {
                type = DefaultFileFormat.TINY_FILE_FORMAT_TYPE;
            }
            if ((fileFormat = fileFormats.get(type)) == null) {
                LOGGER.logMessage(LogLevel.ERROR, "\u6587\u4ef6\u683c\u5f0f\u5316\u5de5\u5177\uff1a{0}\u672a\u627e\u5230", new Object[]{type});
                throw new FlowComponentException("0TE120123008", type);
            }
            String fileContent = fileFormat.formatObject(t);
            FileObject fileObject = VFS.resolveFile((String)filePath);
            OutputStreamWriter write = new OutputStreamWriter(fileObject.getOutputStream(), fileFormat.getEncoding());
            BufferedWriter writer = new BufferedWriter(write);
            writer.write(fileContent);
            writer.close();
        }
        catch (FlowComponentException e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5bf9\u8c61\uff1a{0}\u8f6c\u5b58\u5230\u6587\u4ef6\uff1a{1}\u65f6\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a{2}", new Object[]{t.getClass().getName(), filePath, e});
            throw e;
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5bf9\u8c61\uff1a{0}\u8f6c\u5b58\u5230\u6587\u4ef6\uff1a{1}\u65f6\u51fa\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a{2}", new Object[]{t.getClass().getName(), filePath, e});
            throw new FlowComponentException("0TE120123004", t.getClass().getName(), filePath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void mergeFiles(String outFile, List<String> files) {
        AbstractInterruptibleChannel outChannel = null;
        try {
            outChannel = new FileOutputStream(VFS.resolveFile((String)outFile).getAbsolutePath()).getChannel();
            for (String f : files) {
                String absolutePath = VFS.resolveFile((String)f).getAbsolutePath();
                File file = new File(absolutePath);
                if (!file.exists()) continue;
                FileChannel fc = new FileInputStream(absolutePath).getChannel();
                ByteBuffer bb = ByteBuffer.allocate(8192);
                while (fc.read(bb) != -1) {
                    bb.flip();
                    ((FileChannel)outChannel).write(bb);
                    bb.clear();
                }
                fc.close();
            }
        }
        catch (IOException ioe) {
            try {
                LOGGER.logMessage(LogLevel.ERROR, "\u6587\u4ef6\u5408\u5e76\u5931\u8d25\uff0c\u5408\u5e76\u9884\u671f\u8f93\u51fa\u6587\u4ef6\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{outFile, ioe});
                throw new FlowComponentException("0TE120123010", outFile, ioe);
            }
            catch (Throwable throwable) {
                try {
                    if (outChannel == null) throw throwable;
                    outChannel.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    LOGGER.logMessage(LogLevel.ERROR, "\u6587\u4ef6\u5408\u5e76\u5931\u8d25\uff0c\u5408\u5e76\u9884\u671f\u8f93\u51fa\u6587\u4ef6\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{outFile, ignore});
                    throw new FlowComponentException("0TE120123010", outFile, ignore);
                }
            }
        }
        try {
            if (outChannel == null) return;
            outChannel.close();
            return;
        }
        catch (IOException ignore) {
            LOGGER.logMessage(LogLevel.ERROR, "\u6587\u4ef6\u5408\u5e76\u5931\u8d25\uff0c\u5408\u5e76\u9884\u671f\u8f93\u51fa\u6587\u4ef6\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{outFile, ignore});
            throw new FlowComponentException("0TE120123010", outFile, ignore);
        }
    }

    public static long getFileSize(String filePath) {
        FileObject fileObject = VFS.resolveFile((String)filePath);
        if (!fileObject.isExist()) {
            LOGGER.logMessage(LogLevel.ERROR, "\u6587\u4ef6\uff1a{0}\u4e0d\u5b58\u5728", new Object[]{filePath});
            throw new FlowComponentException("0TE120123007", filePath);
        }
        return fileObject.getSize();
    }

    static {
        Collection collection = BeanContainerFactory.getBeanContainer((ClassLoader)FileUtil.class.getClassLoader()).getBeans(FileFormat.class);
        for (FileFormat fileFormat : collection) {
            fileFormats.put(fileFormat.getType(), fileFormat);
        }
    }
}

