/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowbasiccomponent.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.tinygroup.flowbasiccomponent.exception.FlowComponentException;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;

public class IniOperatorUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(IniOperatorUtil.class);

    public static String getProperty(String filePath, String section, String variable) {
        return IniOperatorUtil.readFile(filePath, section, variable);
    }

    private static String readFile(String filePath, String section, String variable) {
        try {
            FileObject fileObject = VFS.resolveFile((String)filePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), "UTF-8"));
            String line = null;
            String value = "";
            boolean isSection = false;
            while ((line = reader.readLine()) != null) {
                int i;
                String key;
                if ((line = line.trim()).matches("^\\#.*$")) continue;
                if (line.matches("^\\[\\S+\\]$")) {
                    String currentSection = line.replaceFirst("^\\[(\\S+)\\]$", "$1");
                    if (!section.equals(currentSection)) continue;
                    isSection = true;
                    continue;
                }
                if (!line.matches("^\\S+=.*$") || !isSection || !variable.equals(key = line.substring(0, i = line.indexOf("=")).trim())) continue;
                value = line.substring(i + 1).trim();
            }
            return value;
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "ini\u6587\u4ef6\uff1a{0}\u8bfb\u53d6\u5c5e\u6027\u57df\uff1a{1}\u7684\u5c5e\u6027\uff1a{2}\u65f6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{3}", new Object[]{filePath, section, variable, e});
            throw new FlowComponentException("0TE120123019", filePath, section, variable, e);
        }
    }
}

