/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.flowbasiccomponent.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.tinygroup.flowbasiccomponent.exception.FlowComponentException;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.VFS;

public class MonitorPrintUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(MonitorPrintUtil.class);

    public static void printMonitor(String message, String filePath) {
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(VFS.resolveFile((String)filePath).getAbsolutePath(), true);
            writer.write(message + "\r\n");
        }
        catch (IOException e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5199\u76d1\u63a7\u5931\u8d25\uff1a{0},\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{message, e});
            throw new FlowComponentException("0TE120123021", message, e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                LOGGER.logMessage(LogLevel.ERROR, "\u5199\u6587\u4ef6\u5668\u5173\u95ed\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

