/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.httpclient31.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.context.Context;
import org.tinygroup.httpclient31.body.InputStreamPartSource;
import org.tinygroup.httpclient31.cert.AuthSSLProtocolSocketFactory;
import org.tinygroup.httpclient31.response.DefaultResponse;
import org.tinygroup.httpvisitor.BodyElement;
import org.tinygroup.httpvisitor.Certifiable;
import org.tinygroup.httpvisitor.Cookie;
import org.tinygroup.httpvisitor.Header;
import org.tinygroup.httpvisitor.Request;
import org.tinygroup.httpvisitor.Response;
import org.tinygroup.httpvisitor.client.AbstractClient;
import org.tinygroup.httpvisitor.client.ClientInterface;
import org.tinygroup.httpvisitor.execption.HttpVisitorException;
import org.tinygroup.httpvisitor.struct.KeyCert;
import org.tinygroup.httpvisitor.struct.Parameter;
import org.tinygroup.httpvisitor.struct.PasswordCert;
import org.tinygroup.httpvisitor.struct.Proxy;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientImpl
extends AbstractClient
implements ClientInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientImpl.class);
    private static final String DEFAULT_USER_AGENT = "HttpClient3.1";
    private HttpClient httpClient;
    private HttpMethodBase method;
    private boolean followRedirects = true;
    private String userAgent = "HttpClient3.1";
    private Charset requestCharset = DEFAULT_REQUEST_CHARSET;

    public void close() throws IOException {
        if (this.method != null) {
            this.method.releaseConnection();
        }
    }

    public void init(Context context) {
        LOGGER.logMessage(LogLevel.DEBUG, "\u6b63\u5728\u521d\u59cb\u5316HTTP\u901a\u8baf\u5ba2\u6237\u7aef...");
        this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        Integer connectTime = (Integer)context.get("connect-time");
        Integer socketTime = (Integer)context.get("socket-time");
        this.initTimeOut(connectTime, socketTime);
        this.followRedirects = (Boolean)context.get("allow-redirect");
        this.userAgent = (String)context.get("User-Agent", (Object)DEFAULT_USER_AGENT);
        Proxy proxy = (Proxy)context.get("proxy");
        this.initProxy(proxy);
        Certifiable cert = (Certifiable)context.get("cert");
        this.initCert(cert);
        LOGGER.logMessage(LogLevel.DEBUG, "\u521d\u59cb\u5316HTTP\u901a\u8baf\u5ba2\u6237\u7aef\u5b8c\u6210!");
    }

    protected Response executeMethod() {
        try {
            this.httpClient.executeMethod((HttpMethod)this.method);
            return new DefaultResponse(this.method, this.httpClient.getState());
        }
        catch (Exception e) {
            throw new HttpVisitorException("\u6267\u884cHTTP\u8bbf\u95ee\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    protected void initTimeOut(int connectTime, int socketTime) {
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(connectTime);
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(socketTime);
    }

    protected void initProxy(Proxy proxy) {
        if (proxy != null) {
            this.httpClient.getHostConfiguration().setProxy(proxy.getHost(), proxy.getPort());
            if (proxy.getProxyName() != null && proxy.getPassword() != null) {
                this.httpClient.getState().setProxyCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxy.getProxyName(), proxy.getPassword()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initKeyCert(KeyCert cert) {
        try {
            KeyStore keyStore = KeyStore.getInstance(cert.getCertType());
            FileObject certObjcet = VFS.resolveFile((String)cert.getCertPath());
            char[] password = cert.getPassword().toCharArray();
            try {
                keyStore.load(certObjcet.getInputStream(), password);
            }
            finally {
                certObjcet.clean();
            }
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(keyStore, password);
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(factory.getKeyManagers(), null, null);
            AuthSSLProtocolSocketFactory protocolSocketFactory = new AuthSSLProtocolSocketFactory(VFS.resolveFile((String)cert.getCertPath()), cert.getPassword(), null, null);
            Protocol authhttps = new Protocol("https", (ProtocolSocketFactory)protocolSocketFactory, 443);
            Protocol.registerProtocol((String)"https", (Protocol)authhttps);
        }
        catch (Exception e) {
            throw new HttpVisitorException("\u521d\u59cb\u5316\u8bc1\u4e66\u8ba4\u8bc1\u53d1\u751f\u5f02\u5e38", e);
        }
    }

    protected void initPasswordCert(PasswordCert cert) {
        AuthScope authScope = new AuthScope(this.httpClient.getHostConfiguration().getHost(), this.httpClient.getHostConfiguration().getPort());
        this.httpClient.getState().setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(cert.getUserName(), cert.getPassword()));
    }

    protected void dealCookies(List<Cookie> cookies) {
        if (!CollectionUtil.isEmpty(cookies)) {
            this.httpClient.getParams().setCookiePolicy("compatibility");
            this.httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
            for (Cookie cookie : cookies) {
                this.httpClient.getState().addCookie(new org.apache.commons.httpclient.Cookie(cookie.getDomain() == null ? this.method.getHostConfiguration().getHost() : cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath() == null ? this.method.getPath() : cookie.getPath(), cookie.getExpiryDate(), cookie.isSecure()));
            }
        } else {
            this.httpClient.getParams().setCookiePolicy("ignoreCookies");
        }
    }

    protected void dealHeaders(List<Header> headers) {
        if (!CollectionUtil.isEmpty(headers)) {
            for (Header header : headers) {
                this.method.addRequestHeader(header.getName(), header.getValue());
            }
        }
        this.dealDefaultHeader("User-Agent", this.userAgent);
    }

    private void dealDefaultHeader(String name, String value) {
        if (this.method.getRequestHeader(name) == null) {
            this.method.addRequestHeader(name, value);
        }
    }

    protected void dealBodyElement(List<BodyElement> bodyElements) {
        try {
            if (this.method instanceof EntityEnclosingMethod && !CollectionUtil.isEmpty(bodyElements)) {
                EntityEnclosingMethod entityMethod = (EntityEnclosingMethod)this.method;
                if (bodyElements.size() == 1) {
                    BodyElement element = bodyElements.get(0);
                    switch (element.getType()) {
                        case STRING: {
                            entityMethod.setRequestEntity((RequestEntity)new StringRequestEntity((String)element.getElement(), element.getContentType(), element.getCharset() == null ? this.requestCharset.name() : element.getCharset()));
                            break;
                        }
                        case BYTEARRAY: {
                            entityMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity((byte[])element.getElement(), element.getContentType()));
                            break;
                        }
                        case INPUTSTREAM: {
                            entityMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)element.getElement(), element.getContentType()));
                            break;
                        }
                        case FILE: {
                            entityMethod.setRequestEntity((RequestEntity)new FileRequestEntity((File)element.getElement(), element.getContentType()));
                        }
                    }
                } else {
                    Part[] parts = new Part[bodyElements.size()];
                    block14: for (int i = 0; i < bodyElements.size(); ++i) {
                        BodyElement element = bodyElements.get(i);
                        switch (element.getType()) {
                            case STRING: {
                                parts[i] = new StringPart(element.getName(), (String)element.getElement(), element.getCharset() == null ? this.requestCharset.name() : element.getCharset());
                                continue block14;
                            }
                            case BYTEARRAY: {
                                parts[i] = new FilePart(element.getName(), (PartSource)new ByteArrayPartSource(element.getName(), (byte[])element.getElement()), element.getContentType(), element.getCharset());
                                continue block14;
                            }
                            case INPUTSTREAM: {
                                parts[i] = new FilePart(element.getName(), (PartSource)new InputStreamPartSource(element.getName(), (InputStream)element.getElement()), element.getContentType(), element.getCharset());
                                continue block14;
                            }
                            case FILE: {
                                parts[i] = new FilePart(element.getName(), (File)element.getElement(), element.getContentType(), element.getCharset());
                            }
                        }
                    }
                    entityMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, (HttpMethodParams)this.httpClient.getParams()));
                }
            }
        }
        catch (Exception e) {
            throw new HttpVisitorException("\u5904\u7406HTTP\u6b63\u6587\u53d1\u751f\u5f02\u5e38!", e);
        }
    }

    protected void dealHttpMethod(Request request) {
        this.requestCharset = this.getCharset(request);
        switch (request.getMethod()) {
            case GET: {
                this.method = new GetMethod(this.getUrl(request));
                this.method.setFollowRedirects(this.followRedirects);
                break;
            }
            case POST: {
                PostMethod post = new PostMethod(request.getUrl());
                this.addPostParameter(post, request.getParameters());
                this.method = post;
                break;
            }
            case HEAD: {
                this.method = new HeadMethod(this.getUrl(request));
                this.method.setFollowRedirects(this.followRedirects);
                break;
            }
            case PUT: {
                this.method = new PutMethod(this.getUrl(request));
                break;
            }
            case PATCH: {
                throw new HttpVisitorException("\u672cHttpVisitor\u5b9e\u73b0\u4e0d\u652f\u6301PATCH\u64cd\u4f5c!");
            }
            case DELETE: {
                this.method = new DeleteMethod(this.getUrl(request));
                this.method.setFollowRedirects(this.followRedirects);
                break;
            }
            case OPTIONS: {
                this.method = new OptionsMethod(this.getUrl(request));
                this.method.setFollowRedirects(this.followRedirects);
                break;
            }
            case TRACE: {
                this.method = new TraceMethod(this.getUrl(request));
                this.method.setFollowRedirects(this.followRedirects);
            }
        }
    }

    private void addPostParameter(PostMethod post, List<Parameter> parameters) {
        if (!CollectionUtil.isEmpty(parameters)) {
            for (Parameter p : parameters) {
                String key = p.getName();
                Object value = p.getValue();
                if (value.getClass().isArray()) {
                    Object[] arrayValue;
                    for (Object o : arrayValue = (Object[])value) {
                        post.addParameter(key, o.toString());
                    }
                    continue;
                }
                post.setParameter(key, value.toString());
            }
        }
    }
}

