/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.httpclient31.response;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.tinygroup.httpclient31.wrapper.CookieArrayWrapper;
import org.tinygroup.httpclient31.wrapper.HeaderArrayWrapper;
import org.tinygroup.httpclient31.wrapper.StatusLineWrapper;
import org.tinygroup.httpvisitor.Cookie;
import org.tinygroup.httpvisitor.Header;
import org.tinygroup.httpvisitor.Response;
import org.tinygroup.httpvisitor.StatusLine;
import org.tinygroup.httpvisitor.response.AbstractResponse;

public class DefaultResponse
extends AbstractResponse
implements Response {
    private HttpMethodBase method;
    private HttpState state;
    private StatusLine statusLine;

    public DefaultResponse(HttpMethodBase method, HttpState state) {
        this.method = method;
        this.state = state;
    }

    public void close() throws IOException {
        this.method.releaseConnection();
        this.state.clear();
    }

    public StatusLine getStatusLine() {
        if (this.statusLine == null) {
            this.statusLine = new StatusLineWrapper(this.method.getStatusLine());
        }
        return this.statusLine;
    }

    public Header[] getHeaders() {
        return new HeaderArrayWrapper(this.method.getResponseHeaders()).getHeaders();
    }

    public Cookie[] getCookies() {
        return new CookieArrayWrapper(this.state.getCookies()).getCookies();
    }

    protected InputStream getSourceInputStream() throws IOException {
        return this.method.getResponseBodyAsStream();
    }

    protected Response self() {
        return this;
    }
}

