/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.extend;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.tinygroup.jsqlparser.expression.Expression;
import org.tinygroup.jsqlparser.expression.ExpressionVisitorAdapter;
import org.tinygroup.jsqlparser.expression.JdbcParameter;
import org.tinygroup.jsqlparser.expression.operators.relational.ExpressionList;
import org.tinygroup.jsqlparser.expression.operators.relational.GreaterThan;
import org.tinygroup.jsqlparser.expression.operators.relational.GreaterThanEquals;
import org.tinygroup.jsqlparser.expression.operators.relational.MinorThan;
import org.tinygroup.jsqlparser.expression.operators.relational.MinorThanEquals;
import org.tinygroup.jsqlparser.expression.operators.relational.MultiExpressionList;
import org.tinygroup.jsqlparser.statement.select.SelectVisitor;
import org.tinygroup.jsqlparser.statement.select.SubSelect;

public class ParameterExpressionVisitor
extends ExpressionVisitorAdapter {
    public static final String GREATER_THAN = "greaterThan";
    public static final String GREATER_THAN_EQUALS = "greaterThanEquals";
    public static final String MINOR_THAN_EQUALS = "minorThanEquals";
    public static final String MINOR_THAN = "minorThan";
    private Map<String, Integer> positionMap;
    private AtomicInteger paramLength;
    private SelectVisitor selectVisitor;

    public ParameterExpressionVisitor(Map<String, Integer> positionMap, AtomicInteger paramLength, SelectVisitor selectVisitor) {
        this.positionMap = positionMap;
        this.paramLength = paramLength;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void visit(JdbcParameter parameter) {
        this.paramLength.incrementAndGet();
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    @Override
    public void visit(ExpressionList expressionList) {
        List<Expression> expressions = expressionList.getExpressions();
        if (expressions != null) {
            for (Expression expression : expressions) {
                expression.accept(this);
            }
        }
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        List<ExpressionList> expressionLists = multiExprList.getExprList();
        if (expressionLists != null) {
            for (ExpressionList expressionList : expressionLists) {
                expressionList.accept(this);
            }
        }
    }

    @Override
    public void visit(GreaterThan expr) {
        int before = this.paramLength.intValue();
        super.visit(expr);
        int after = this.paramLength.intValue();
        if (before != after) {
            this.positionMap.put(GREATER_THAN, after);
        }
    }

    @Override
    public void visit(GreaterThanEquals expr) {
        int before = this.paramLength.intValue();
        super.visit(expr);
        int after = this.paramLength.intValue();
        if (before != after) {
            this.positionMap.put(GREATER_THAN_EQUALS, after);
        }
    }

    @Override
    public void visit(MinorThan expr) {
        int before = this.paramLength.intValue();
        super.visit(expr);
        int after = this.paramLength.intValue();
        if (before != after) {
            this.positionMap.put(MINOR_THAN, after);
        }
    }

    @Override
    public void visit(MinorThanEquals expr) {
        int before = this.paramLength.intValue();
        super.visit(expr);
        int after = this.paramLength.intValue();
        if (before != after) {
            this.positionMap.put(MINOR_THAN_EQUALS, after);
        }
    }
}

