/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.statement.replace;

import java.util.List;
import org.tinygroup.jsqlparser.expression.Expression;
import org.tinygroup.jsqlparser.expression.operators.relational.ItemsList;
import org.tinygroup.jsqlparser.schema.Column;
import org.tinygroup.jsqlparser.schema.Table;
import org.tinygroup.jsqlparser.statement.Statement;
import org.tinygroup.jsqlparser.statement.StatementVisitor;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;

public class Replace
implements Statement {
    private Table table;
    private List<Column> columns;
    private ItemsList itemsList;
    private List<Expression> expressions;
    private boolean useValues = true;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        sql.append("REPLACE ").append(this.table);
        if (this.expressions != null && this.columns != null) {
            sql.append(" SET ");
            int s = this.columns.size();
            for (int i = 0; i < s; ++i) {
                sql.append(this.columns.get(i)).append("=").append(this.expressions.get(i));
                sql.append(i < s - 1 ? ", " : "");
            }
        } else if (this.columns != null) {
            sql.append(" ").append(PlainSelect.getStringList(this.columns, true, true));
        }
        if (this.itemsList != null) {
            if (this.useValues) {
                sql.append(" VALUES");
            }
            sql.append(" ").append(this.itemsList);
        }
        return sql.toString();
    }
}

