/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.jsqlparser.util.deparser;

import org.tinygroup.jsqlparser.statement.create.view.CreateView;
import org.tinygroup.jsqlparser.statement.select.PlainSelect;

public class CreateViewDeParser {
    protected StringBuilder buffer;

    public CreateViewDeParser(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(CreateView createView) {
        this.buffer.append("CREATE ");
        if (createView.isOrReplace()) {
            this.buffer.append("OR REPLACE ");
        }
        if (createView.isMaterialized()) {
            this.buffer.append("MATERIALIZED ");
        }
        this.buffer.append("VIEW ").append(createView.getView().getFullyQualifiedName());
        if (createView.getColumnNames() != null) {
            this.buffer.append(PlainSelect.getStringList(createView.getColumnNames(), true, true));
        }
        this.buffer.append(" AS ");
        this.buffer.append(createView.getSelectBody().toString());
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

