/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.menucommand.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.menucommand.CommandExecutor;
import org.tinygroup.menucommand.CommandHandler;
import org.tinygroup.menucommand.MenuConfigManager;
import org.tinygroup.menucommand.config.BaseCommand;
import org.tinygroup.menucommand.config.MenuCommand;
import org.tinygroup.menucommand.config.MenuConfig;
import org.tinygroup.menucommand.config.MenuConfigs;
import org.tinygroup.menucommand.config.SystemCommand;
import org.tinygroup.menucommand.executor.DefaultCommandExecutor;
import org.tinygroup.menucommand.handler.ShowCommandHandler;
import org.tinygroup.template.TemplateRender;
import org.tinygroup.template.impl.TemplateRenderDefault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuConfigManagerDefault
implements MenuConfigManager {
    private Map<String, MenuConfig> menuConfigMaps = new HashMap<String, MenuConfig>();
    private List<SystemCommand> systemCommandList = new ArrayList<SystemCommand>();
    private TemplateRender templateRender;
    private CommandHandler defaultCommandHandler = new ShowCommandHandler();

    public MenuConfigManagerDefault() {
        this.templateRender = new TemplateRenderDefault();
    }

    public TemplateRender getTemplateRender() {
        return this.templateRender;
    }

    public void setTemplateRender(TemplateRender templateRender) {
        this.templateRender = templateRender;
    }

    @Override
    public void addMenuConfigs(MenuConfigs configs) {
        if (configs != null) {
            if (configs.getMenuConfigList() != null) {
                for (MenuConfig config : configs.getMenuConfigList()) {
                    this.addMenuConfig(config);
                }
            }
            if (configs.getSystemCommandList() != null) {
                for (SystemCommand command : configs.getSystemCommandList()) {
                    this.addSystemCommand(command);
                }
            }
        }
    }

    @Override
    public void removeMenuConfigs(MenuConfigs configs) {
        if (configs != null) {
            if (configs.getMenuConfigList() != null) {
                for (MenuConfig config : configs.getMenuConfigList()) {
                    this.removeMenuConfig(config);
                }
            }
            if (configs.getSystemCommandList() != null) {
                for (SystemCommand command : configs.getSystemCommandList()) {
                    this.removeSystemCommand(command);
                }
            }
        }
    }

    @Override
    public MenuConfig getMenuConfig(String menuId) {
        return this.menuConfigMaps.get(menuId);
    }

    @Override
    public void addMenuConfig(MenuConfig config) {
        List<MenuCommand> commands;
        List<MenuConfig> subMenus = config.getMenuConfigList();
        this.menuConfigMaps.put(config.getId(), config);
        config.compile();
        if (subMenus != null) {
            for (MenuConfig subMenu : subMenus) {
                subMenu.setParent(config);
                this.addMenuConfig(subMenu);
            }
        }
        if ((commands = config.getMenuCommandList()) != null) {
            for (MenuCommand command : commands) {
                command.setMenuConfig(config);
                command.compile();
            }
        }
    }

    @Override
    public void removeMenuConfig(MenuConfig config) {
        List<MenuConfig> subMenus;
        List<MenuCommand> commands = config.getMenuCommandList();
        if (commands != null) {
            for (MenuCommand command : commands) {
                command.setMenuConfig(null);
            }
        }
        if ((subMenus = config.getMenuConfigList()) != null) {
            for (MenuConfig subMenu : subMenus) {
                subMenu.setParent(null);
                this.removeMenuConfig(subMenu);
            }
        }
        this.menuConfigMaps.remove(config.getId());
    }

    @Override
    public void addSystemCommand(SystemCommand command) {
        command.compile();
        if (!this.systemCommandList.contains(command)) {
            this.systemCommandList.add(command);
        }
    }

    @Override
    public void removeSystemCommand(SystemCommand command) {
        this.systemCommandList.remove(command);
    }

    @Override
    public List<SystemCommand> getSystemCommandList() {
        return this.systemCommandList;
    }

    @Override
    public SystemCommand getSystemCommand(String command) {
        for (SystemCommand systemCommand : this.systemCommandList) {
            if (!systemCommand.match(command)) continue;
            return systemCommand;
        }
        return null;
    }

    @Override
    public CommandExecutor getCommandExecutor(String menuId, String command, Context context) {
        context.put("_before_menu_id", (Object)menuId);
        context.put("_user_input_command", (Object)command);
        context.put("systemCommandList", this.systemCommandList);
        if (!StringUtil.isEmpty((String)menuId)) {
            MenuConfig parentConfig = this.menuConfigMaps.get(menuId);
            if (parentConfig == null) {
                return null;
            }
            context.put("menuConfig", (Object)parentConfig);
            MenuCommand menuCommand = parentConfig.getMatchMenuCommand(command);
            SystemCommand systemCommand = this.getSystemCommand(command);
            if (menuCommand != null) {
                context.put("_menu_command", (Object)menuCommand);
                if (menuCommand.isSystemEnable() && systemCommand != null) {
                    context.put("_system_command", (Object)systemCommand);
                    return this.createDefaultCommandExecutor(systemCommand);
                }
                return this.createDefaultCommandExecutor(menuCommand);
            }
            if (systemCommand != null) {
                context.put("_system_command", (Object)systemCommand);
                return this.createDefaultCommandExecutor(systemCommand);
            }
            MenuConfig menuConfig = parentConfig.getMatchMenuConfig(command);
            if (menuConfig != null) {
                context.put("menuConfig", (Object)menuConfig);
                return this.createMenuConfigShowExecutor();
            }
            return this.createMenuConfigShowExecutor();
        }
        for (MenuConfig config : this.menuConfigMaps.values()) {
            if (config.getParent() != null || !config.match(command)) continue;
            context.put("menuConfig", (Object)config);
            return this.createMenuConfigShowExecutor();
        }
        return null;
    }

    protected DefaultCommandExecutor createDefaultCommandExecutor(CommandHandler handler) {
        DefaultCommandExecutor executor = new DefaultCommandExecutor();
        executor.setTemplateRender(this.templateRender);
        executor.setCommandHandler(handler);
        return executor;
    }

    protected DefaultCommandExecutor createDefaultCommandExecutor(BaseCommand baseCommand) {
        return this.createDefaultCommandExecutor((CommandHandler)baseCommand.createCommandObject());
    }

    protected DefaultCommandExecutor createMenuConfigShowExecutor() {
        return this.createDefaultCommandExecutor(this.defaultCommandHandler);
    }
}

