/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.queue;

import java.util.Random;
import junit.framework.TestCase;
import org.tinygroup.commons.exceptions.NotExistException;
import org.tinygroup.queue.impl.PriorityQueueImpl;

public class PriorityQueueTest
extends TestCase {
    static volatile boolean stopIt = false;
    PriorityQueueImpl<Integer> queue = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.queue = new PriorityQueueImpl(500);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testOffer1() {
        this.queue.setTimeslice(500);
        this.queue.offer((Object)1, 5);
        this.queue.offer((Object)2, 5);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.queue.offer((Object)3, 5);
        this.queue.offer((Object)4, 5);
        this.queue.offer((Object)5, 5);
        this.queue.offer((Object)6, 5);
        this.queue.offer((Object)7, 5);
        this.queue.offer((Object)8, 5);
        PriorityQueueTest.assertEquals((int)8, (int)this.queue.getUsingSize());
    }

    public void testPriorityStrategy() {
        PriorityQueueImpl strQ = new PriorityQueueImpl(2);
        strQ.offer((Object)"aa");
        strQ.offer((Object)"bb");
        PriorityQueueTest.assertEquals((String)"aa", (String)((String)strQ.peek()));
        try {
            strQ.offer((Object)"cc");
            PriorityQueueTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testOfferWithPriority() {
        this.queue.offer((Object)1);
        this.queue.offer((Object)3);
        this.queue.offer((Object)2, 2);
        PriorityQueueTest.assertEquals((int)2, (int)((Integer)this.queue.poll()));
        PriorityQueueTest.assertEquals((int)1, (int)((Integer)this.queue.poll()));
        PriorityQueueTest.assertEquals((int)3, (int)((Integer)this.queue.poll()));
    }

    public void testOffer() {
        PriorityQueueTest.assertEquals((int)this.queue.getIdleSize(), (int)this.queue.getSize());
        this.queue.offer((Object)1);
        PriorityQueueTest.assertEquals((int)1, (int)((Integer)this.queue.peek()));
        PriorityQueueTest.assertEquals((int)(this.queue.getIdleSize() + 1), (int)this.queue.getSize());
        PriorityQueueTest.assertEquals((int)1, (int)this.queue.getUsingSize());
        PriorityQueueTest.assertEquals((int)1, (int)((Integer)this.queue.poll()));
        PriorityQueueTest.assertEquals((int)0, (int)this.queue.getUsingSize());
        PriorityQueueTest.assertEquals((int)this.queue.getIdleSize(), (int)this.queue.getSize());
        Integer i2 = new Integer(2);
        this.queue.offer((Object)i2);
        try {
            this.queue.remove();
            this.queue.remove();
            PriorityQueueTest.fail((String)"Error!!");
        }
        catch (NotExistException notExistException) {
            // empty catch block
        }
    }

    public void testElement() {
        this.queue.offer((Object)1);
        try {
            PriorityQueueTest.assertEquals((int)1, (int)((Integer)this.queue.element()));
        }
        catch (NotExistException e) {
            PriorityQueueTest.fail((String)"Error!!");
        }
        this.queue.poll();
        try {
            PriorityQueueTest.assertNull((Object)this.queue.element());
        }
        catch (NotExistException notExistException) {
            // empty catch block
        }
    }

    public void testIsEmpty() {
        PriorityQueueTest.assertEquals((boolean)true, (boolean)this.queue.isEmpty());
    }

    public void testIsFull() {
        for (int i = 0; i < this.queue.getSize(); ++i) {
            this.queue.offer((Object)i);
        }
        PriorityQueueTest.assertEquals((boolean)true, (boolean)this.queue.isFull());
        try {
            this.queue.offer((Object)3);
            PriorityQueueTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetName() {
        PriorityQueueTest.assertEquals((String)"PriorityQueueImpl", (String)this.queue.getName());
    }

    public void testGetSize() {
        PriorityQueueTest.assertEquals((int)500, (int)this.queue.getSize());
    }

    public void testGetUsingLength() {
        int i;
        for (i = 1; i <= 10; ++i) {
            this.queue.offer((Object)i);
            PriorityQueueTest.assertEquals((int)i, (int)this.queue.getUsingSize());
            PriorityQueueTest.assertEquals((int)(500 - i), (int)this.queue.getIdleSize());
        }
        for (i = 10; i >= 1; --i) {
            PriorityQueueTest.assertEquals((int)(500 - i), (int)this.queue.getIdleSize());
            PriorityQueueTest.assertEquals((int)i, (int)this.queue.getUsingSize());
            this.queue.poll();
        }
    }

    class ThreadTest
    extends Thread {
        Random r = new Random(System.currentTimeMillis());

        ThreadTest() {
        }

        public void run() {
            while (!stopIt) {
                if (this.r.nextInt() % 10 <= 5) {
                    if (!PriorityQueueTest.this.queue.isFull()) {
                        PriorityQueueTest.this.queue.offer((Object)1);
                    }
                } else if (!PriorityQueueTest.this.queue.isEmpty()) {
                    PriorityQueueTest.this.queue.poll();
                }
                if (PriorityQueueTest.this.queue.getUsingSize() == PriorityQueueTest.this.queue.getIdleSize()) {
                    stopIt = true;
                }
                try {
                    ThreadTest.sleep(1L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

