/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.queue;

import java.util.Random;
import junit.framework.TestCase;
import org.tinygroup.commons.exceptions.NotExistException;
import org.tinygroup.queue.Queue;
import org.tinygroup.queue.impl.QueueImpl;

public class QueueTest
extends TestCase {
    static volatile boolean stopIt = false;
    static volatile long times = 0L;
    Queue<Integer> queue = null;

    protected void setUp() throws Exception {
        this.queue = new QueueImpl("abc");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testOffer() {
        QueueTest.assertEquals((int)this.queue.getIdleSize(), (int)this.queue.getSize());
        this.queue.offer((Object)1);
        QueueTest.assertEquals((int)1, (int)((Integer)this.queue.peek()));
        QueueTest.assertEquals((int)(this.queue.getIdleSize() + 1), (int)this.queue.getSize());
        QueueTest.assertEquals((int)1, (int)this.queue.getUsingSize());
        QueueTest.assertEquals((int)1, (int)((Integer)this.queue.poll()));
        QueueTest.assertEquals((int)0, (int)this.queue.getUsingSize());
        QueueTest.assertEquals((int)this.queue.getIdleSize(), (int)this.queue.getSize());
        Integer i2 = new Integer(2);
        this.queue.offer((Object)i2);
        try {
            this.queue.remove();
            this.queue.remove();
            QueueTest.fail((String)"Error!!");
        }
        catch (NotExistException notExistException) {
            // empty catch block
        }
    }

    public void testElement() {
        this.queue.offer((Object)1);
        try {
            QueueTest.assertEquals((int)1, (int)((Integer)this.queue.element()));
        }
        catch (NotExistException e) {
            QueueTest.fail((String)"Error!!");
        }
        this.queue.poll();
        try {
            QueueTest.assertNull((Object)this.queue.element());
        }
        catch (NotExistException notExistException) {
            // empty catch block
        }
    }

    public void testIsEmpty() {
        QueueTest.assertEquals((boolean)true, (boolean)this.queue.isEmpty());
    }

    public void testIsFull() {
        for (int i = 0; i < this.queue.getSize(); ++i) {
            this.queue.offer((Object)i);
        }
        QueueTest.assertEquals((boolean)true, (boolean)this.queue.isFull());
        try {
            this.queue.offer((Object)3);
            QueueTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetName() {
        QueueTest.assertEquals((String)"abc", (String)this.queue.getName());
    }

    public void testGetSize() {
        QueueTest.assertEquals((int)500, (int)this.queue.getSize());
    }

    public void testGetUsingLength() {
        int i;
        for (i = 1; i <= 10; ++i) {
            this.queue.offer((Object)i);
            QueueTest.assertEquals((int)i, (int)this.queue.getUsingSize());
            QueueTest.assertEquals((int)(500 - i), (int)this.queue.getIdleSize());
        }
        for (i = 10; i >= 1; --i) {
            QueueTest.assertEquals((int)(500 - i), (int)this.queue.getIdleSize());
            QueueTest.assertEquals((int)i, (int)this.queue.getUsingSize());
            this.queue.poll();
        }
    }

    class ThreadTest
    extends Thread {
        Random r;

        public ThreadTest() {
            super("ThreadTest");
            this.r = new Random(System.currentTimeMillis());
        }

        public void run() {
            while (!stopIt) {
                if (++times == 100000L) {
                    stopIt = true;
                }
                if (this.r.nextInt() % 10 <= 5) {
                    if (!QueueTest.this.queue.isFull()) {
                        QueueTest.this.queue.offer((Object)1);
                    }
                } else if (!QueueTest.this.queue.isEmpty()) {
                    QueueTest.this.queue.poll();
                }
                if (QueueTest.this.queue.getUsingSize() == QueueTest.this.queue.getIdleSize()) {
                    stopIt = true;
                }
                try {
                    ThreadTest.sleep(1L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

