/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.queue.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.tinygroup.commons.exceptions.NotExistException;
import org.tinygroup.queue.PriorityIncreaseStrategy;
import org.tinygroup.queue.PriorityQueue;
import org.tinygroup.queue.Queue;
import org.tinygroup.queue.QueueMonitor;
import org.tinygroup.queue.impl.DefaultPriorityIncreaseStrategy;
import org.tinygroup.queue.impl.QueueImpl;

public class PriorityQueueImpl<T>
implements PriorityQueue<T>,
QueueMonitor {
    private static final int ZERO = 0;
    private static final int DEFAULT_REVERSE_LEVEL = 3;
    private static final int DEFAULT_PRIORITY_LEVEL = 10;
    private static final int DEFAULT_TIMESLICE = 1000;
    List<DateQueue<T>>[] dateQueueListArray;
    private int timeslice = 1000;
    private int maxSize = 500;
    private int priorityLevel = 10;
    private int size = 0;
    private int reverseLevel = 3;
    private int callTimes = 0;
    private PriorityIncreaseStrategy<T> strategy = new DefaultPriorityIncreaseStrategy<T>();
    private String name;

    public PriorityQueueImpl() {
        this(500, 10);
    }

    public PriorityQueueImpl(int size) {
        this(size, 10);
    }

    public PriorityQueueImpl(int size, int priorityLevel) {
        this.maxSize = size;
        this.priorityLevel = priorityLevel;
        this.dateQueueListArray = new List[priorityLevel];
        for (int i = 0; i < priorityLevel; ++i) {
            this.dateQueueListArray[i] = new ArrayList<DateQueue<T>>();
        }
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public int getCount() {
        return this.size;
    }

    public List<DateQueue<T>>[] getDateQueueListArray() {
        return this.dateQueueListArray;
    }

    public int getCallTimes() {
        return this.callTimes;
    }

    public PriorityIncreaseStrategy<T> getStrategy() {
        return this.strategy;
    }

    public PriorityIncreaseStrategy<T> getPriorityIncreaseStrategy() {
        return this.strategy;
    }

    @Override
    public void setPriorityIncreaseStrategy(PriorityIncreaseStrategy<T> strategy) {
        this.strategy = strategy;
    }

    public int getReverseLevel() {
        return this.reverseLevel;
    }

    public void setReverseLevel(int reverseLevel) {
        this.reverseLevel = reverseLevel;
    }

    public int getTimeslice() {
        return this.timeslice;
    }

    public void setTimeslice(int timeslice) {
        this.timeslice = timeslice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(T o, int pPriority) {
        int priority = pPriority;
        List<DateQueue<T>>[] listArray = this.dateQueueListArray;
        synchronized (this.dateQueueListArray) {
            if (priority > this.priorityLevel || priority < 0) {
                priority = this.priorityLevel;
            }
            if (this.strategy != null && this.maxSize > 0) {
                this.strategy.increasePriority(this);
            }
            if (this.size != this.maxSize || this.maxSize == 0) {
                DateQueue<T> dateQueue;
                List<DateQueue<T>> dateQueueList = this.dateQueueListArray[priority - 1];
                if (dateQueueList.size() > 0 && !((DateQueue)(dateQueue = dateQueueList.get(dateQueueList.size() - 1))).queue.isFull() && new Date().getTime() - ((DateQueue)dateQueue).date.getTime() < (long)this.timeslice) {
                    ((DateQueue)dateQueue).queue.offer(o);
                    ++this.size;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                int s = this.maxSize;
                if (this.maxSize > this.priorityLevel) {
                    s = this.maxSize / this.priorityLevel;
                }
                DateQueue dateQueue2 = new DateQueue(new QueueImpl(s));
                dateQueue2.queue.offer(o);
                dateQueueList.add(dateQueue2);
                ++this.size;
            } else {
                throw new RuntimeException("\u4f18\u5148\u961f\u5217\u5df2\u6ee1\uff01");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void offer(T o) {
        this.offer(o, this.priorityLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        List<DateQueue<T>>[] listArray = this.dateQueueListArray;
        synchronized (this.dateQueueListArray) {
            if (this.size > 0) {
                for (List<DateQueue<T>> dateQueueList : this.dateQueueListArray) {
                    if (dateQueueList.size() <= 0) continue;
                    DateQueue<T> dateQueue = dateQueueList.get(0);
                    Object t = ((DateQueue)dateQueue).queue.poll();
                    if (((DateQueue)dateQueue).queue.isEmpty()) {
                        dateQueueList.remove(0);
                    }
                    --this.size;
                    ++this.callTimes;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return (T)t;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw new RuntimeException("\u4f18\u5148\u961f\u5217\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public T remove() {
        List<DateQueue<T>>[] listArray = this.dateQueueListArray;
        synchronized (this.dateQueueListArray) {
            if (this.size > 0) {
                for (List<DateQueue<T>> dateQueueList : this.dateQueueListArray) {
                    if (dateQueueList.size() <= 0) continue;
                    DateQueue<T> dateQueue = dateQueueList.get(0);
                    Object t = ((DateQueue)dateQueue).queue.poll();
                    if (((DateQueue)dateQueue).queue.isEmpty()) {
                        dateQueueList.remove(0);
                    }
                    --this.size;
                    ++this.callTimes;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return (T)t;
                }
            }
            throw new NotExistException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        List<DateQueue<T>>[] listArray = this.dateQueueListArray;
        synchronized (this.dateQueueListArray) {
            if (this.size > 0) {
                for (List<DateQueue<T>> dateQueueList : this.dateQueueListArray) {
                    if (dateQueueList.size() <= 0) continue;
                    DateQueue<T> dateQueue = dateQueueList.get(0);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return (T)((DateQueue)dateQueue).queue.peek();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw new RuntimeException("\u4f18\u5148\u961f\u5217\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public T element() {
        List<DateQueue<T>>[] listArray = this.dateQueueListArray;
        synchronized (this.dateQueueListArray) {
            if (this.size > 0) {
                for (List<DateQueue<T>> dateQueueList : this.dateQueueListArray) {
                    if (dateQueueList.size() <= 0) continue;
                    DateQueue<T> dateQueue = dateQueueList.get(0);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return (T)((DateQueue)dateQueue).queue.peek();
                }
            }
            throw new NotExistException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        List<DateQueue<T>>[] listArray = this.dateQueueListArray;
        synchronized (this.dateQueueListArray) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.size == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFull() {
        List<DateQueue<T>>[] listArray = this.dateQueueListArray;
        synchronized (this.dateQueueListArray) {
            if (this.maxSize == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.size == this.maxSize;
        }
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getClass().getSimpleName();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUsingSize() {
        List<DateQueue<T>>[] listArray = this.dateQueueListArray;
        synchronized (this.dateQueueListArray) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIdleSize() {
        List<DateQueue<T>>[] listArray = this.dateQueueListArray;
        synchronized (this.dateQueueListArray) {
            if (this.maxSize == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Short.MAX_VALUE;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.maxSize - this.size;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    private class DateQueue<DT> {
        private Date date;
        private Queue<DT> queue;

        DateQueue(Queue<DT> queue) {
            this(new Date(), queue);
        }

        DateQueue(Date date, Queue<DT> queue) {
            this.date = date;
            this.queue = queue;
        }
    }
}

