/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript;

import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.tinyscript.ScriptEngine;
import org.tinygroup.tinyscript.ScriptEngineBuilder;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.impl.DefaultScriptEngine;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public final class ScriptEngineFactory {
    private ScriptEngineFactory() {
    }

    public static ScriptEngine createByClass() throws ScriptException {
        return new DefaultScriptEngine();
    }

    public static ScriptEngine createByBean() throws ScriptException {
        String scriptEngineBean = ConfigurationUtil.getConfigurationManager().getConfiguration("defaultScriptEngine");
        if (scriptEngineBean == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("application.item.undefine", "defaultScriptEngine"));
        }
        return ScriptEngineFactory.createByBean(scriptEngineBean);
    }

    public static ScriptEngine createByBean(String scriptEngineBean) throws ScriptException {
        return ScriptEngineFactory.createByBean("scriptEngineBuilder", scriptEngineBean);
    }

    public static ScriptEngine createByBean(String builderBean, String scriptEngineBean) throws ScriptException {
        try {
            ScriptEngine scriptEngine = (ScriptEngine)BeanContainerFactory.getBeanContainer((ClassLoader)ScriptEngineFactory.class.getClassLoader()).getBean(scriptEngineBean);
            ScriptEngineBuilder builder = (ScriptEngineBuilder)BeanContainerFactory.getBeanContainer((ClassLoader)ScriptEngineBuilder.class.getClassLoader()).getBean(builderBean);
            builder.registerComponent(scriptEngine);
            builder.registerProcessor(scriptEngine);
            return scriptEngine;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("class.intance.build", "ScriptEngine"), e);
        }
    }

    public static void register(ScriptEngine scriptEngine) throws ScriptException {
        ScriptEngineBuilder builder = (ScriptEngineBuilder)BeanContainerFactory.getBeanContainer((ClassLoader)ScriptEngineBuilder.class.getClassLoader()).getBean("scriptEngineBuilder");
        ScriptEngineFactory.register(scriptEngine, builder);
    }

    public static void register(ScriptEngine scriptEngine, ScriptEngineBuilder builder) throws ScriptException {
        builder.registerComponent(scriptEngine);
        builder.registerProcessor(scriptEngine);
    }
}

