/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.analysis.AnalysisModelProcessor;
import org.tinygroup.tinyscript.analysis.TrendLineProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public final class AnalysisModelUtil {
    private static Map<String, AnalysisModelProcessor> processorMap = new HashMap<String, AnalysisModelProcessor>();

    private AnalysisModelUtil() {
    }

    public static void addProcessor(AnalysisModelProcessor processor) {
        processorMap.put(processor.getName(), processor);
    }

    public static void removeProcessor(String modelName) {
        processorMap.remove(modelName);
    }

    public static boolean exsitAnalysisModel(String modelName) {
        return processorMap.containsKey(modelName);
    }

    public static List<String> getAnalysisModelNames() {
        return new ArrayList<String>(processorMap.keySet());
    }

    public static List<Object> analyse(String modelName, List<Object> dataList, ScriptContext context, Object ... configs) throws ScriptException {
        AnalysisModelProcessor processor = processorMap.get(modelName);
        if (processor == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("analysis.model.nofound", modelName));
        }
        return processor.analyse(dataList, context, configs);
    }

    static {
        AnalysisModelUtil.addProcessor(new TrendLineProcessor());
    }
}

