/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.analysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.analysis.AnalysisModelProcessor;
import org.tinygroup.tinyscript.expression.ExpressionUtil;

public class TrendLineProcessor
implements AnalysisModelProcessor {
    @Override
    public String getName() {
        return "trendLine";
    }

    @Override
    public List<Object> analyse(List<Object> dataList, ScriptContext context, Object ... configs) throws ScriptException {
        double xs = 0.0;
        double ys = 0.0;
        double xxs = 0.0;
        double xys = 0.0;
        int num = dataList.size();
        int scale = 2;
        if (configs != null && configs.length > 0) {
            scale = ExpressionUtil.convertInteger(configs[0]);
        }
        for (int i = 0; i < num; ++i) {
            double y = ExpressionUtil.convertDouble(dataList.get(i));
            xs += (double)(i + 1);
            ys += y;
            xxs += (double)((i + 1) * (i + 1));
            xys += (double)(i + 1) * y;
        }
        double a = ((double)num * xys - xs * ys) / ((double)num * xxs - xs * xs);
        double b = ys / (double)num - a * xs / (double)num;
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < num; ++i) {
            double y = new BigDecimal(a * (double)(i + 1) + b).setScale(scale, 4).doubleValue();
            result.add(y);
        }
        return result;
    }
}

