/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.assignvalue;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.assignvalue.AssignValueProcessor;
import org.tinygroup.tinyscript.assignvalue.ClassFieldAssignValueProcessor;
import org.tinygroup.tinyscript.assignvalue.DefaultAssignValueProcessor;
import org.tinygroup.tinyscript.assignvalue.FieldAssignValueProcessor;
import org.tinygroup.tinyscript.assignvalue.MapAssignValueProcessor;
import org.tinygroup.tinyscript.assignvalue.ObjectItemAssignValueProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public class AssignValueUtil {
    private static List<AssignValueProcessor> processors = new ArrayList<AssignValueProcessor>();

    public static void addAssignValueProcessor(AssignValueProcessor processor) {
        for (AssignValueProcessor assignValueProcessor : processors) {
            if (!assignValueProcessor.equals(processor) && !assignValueProcessor.getClass().isInstance(processor)) continue;
            return;
        }
        processors.add(0, processor);
    }

    public static void removeAssignValueProcessor(AssignValueProcessor processor) {
        processors.remove(processor);
    }

    public static void operate(String name, Object value, ScriptContext context) throws Exception {
        for (AssignValueProcessor processor : processors) {
            if (!processor.isMatch(name, context)) continue;
            processor.process(name, value, context);
            return;
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("unmatch.info1", AssignValueProcessor.class.getName()));
    }

    static {
        AssignValueUtil.addAssignValueProcessor(new DefaultAssignValueProcessor());
        AssignValueUtil.addAssignValueProcessor(new MapAssignValueProcessor());
        AssignValueUtil.addAssignValueProcessor(new FieldAssignValueProcessor());
        AssignValueUtil.addAssignValueProcessor(new ClassFieldAssignValueProcessor());
        AssignValueUtil.addAssignValueProcessor(new ObjectItemAssignValueProcessor());
    }
}

