/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.assignvalue;

import org.tinygroup.tinyscript.ScriptClassInstance;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.assignvalue.AssignValueProcessor;
import org.tinygroup.tinyscript.interpret.ScriptContextUtil;

public class ClassFieldAssignValueProcessor
implements AssignValueProcessor {
    @Override
    public boolean isMatch(String name, ScriptContext context) {
        String className = null;
        String fieldName = null;
        String[] infos = this.dealName(name);
        boolean thisTag = false;
        if (infos != null && infos.length > 1) {
            if ("this".equals(infos[0])) {
                className = null;
                thisTag = true;
            } else {
                className = infos[0];
            }
            fieldName = infos[1];
        } else {
            fieldName = name;
        }
        ScriptClassInstance instance = null;
        if (className != null) {
            Object obj = context.get(className);
            if (obj instanceof ScriptClassInstance) {
                instance = (ScriptClassInstance)obj;
            }
        } else {
            instance = ScriptContextUtil.getScriptClassInstance(context);
        }
        if (instance != null) {
            if (thisTag) {
                return instance.existField(fieldName);
            }
            return instance.existField(fieldName) && !context.getItemMap().containsKey(fieldName);
        }
        return false;
    }

    @Override
    public void process(String name, Object value, ScriptContext context) throws Exception {
        String className = null;
        String fieldName = null;
        String[] infos = this.dealName(name);
        if (infos != null && infos.length > 1) {
            className = "this".equals(infos[0]) ? null : infos[0];
            fieldName = infos[1];
        } else {
            fieldName = name;
        }
        ScriptClassInstance instance = null;
        instance = className != null ? (ScriptClassInstance)context.get(className) : ScriptContextUtil.getScriptClassInstance(context);
        if (instance != null) {
            instance.setField(fieldName, value);
            instance.setScriptContext(context);
        }
    }

    private String[] dealName(String name) {
        return name.split("\\.");
    }
}

