/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.executor;

import java.io.File;
import org.apache.commons.lang.StringEscapeUtils;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptEngine;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.executor.TinyScriptOperator;
import org.tinygroup.tinyscript.impl.DefaultScriptContext;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptUtil;

public abstract class AbstractTinyScriptOperator
implements TinyScriptOperator {
    @Override
    public void execute(String[] args) throws ScriptException {
        String relativePath = null;
        String absolutePath = null;
        String methodScript = null;
        if (args.length >= 1) {
            relativePath = args[0].replaceAll("\\\\", "/");
        }
        if (args.length >= 2) {
            absolutePath = args[1].replaceAll("\\\\", "/");
        }
        if (args.length >= 3) {
            methodScript = args[2].replaceAll("'", "\"");
        }
        ScriptEngine engine = this.createScriptEngine();
        DefaultScriptContext context = new DefaultScriptContext();
        context.setParent(engine.getScriptContext());
        try {
            String content = FileUtil.readFileContent((File)new File(absolutePath), (String)"utf-8");
            content = StringEscapeUtils.unescapeJava((String)content);
            ScriptSegment scriptSegment = ScriptUtil.getDefault().createScriptSegment(engine, null, content);
            engine.addScriptSegment(scriptSegment);
            engine.execute(scriptSegment, (ScriptContext)context);
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("engine.run.error", absolutePath), e);
        }
    }
}

