/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.executor;

import java.io.File;
import java.io.PrintStream;
import org.tinygroup.tinyrunner.Runner;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.executor.DefaultTinyScriptOperator;
import org.tinygroup.tinyscript.executor.TinyScriptOperator;

public class DefaultTinyScriptExecutor {
    private static TinyScriptOperator operator = new DefaultTinyScriptOperator();

    public static void main(String[] args) throws ScriptException {
        if (args.length == 0) {
            System.out.println("Usage:\n\tDefaultTinyScriptExecutor tinyScriptFile [relativePath] [absolutePath] [resources] ");
            return;
        }
        File logfile = DefaultTinyScriptExecutor.getLogFile(args);
        DefaultTinyScriptExecutor.initSpring(logfile);
        operator.execute(args);
    }

    private static File getLogFile(String[] args) throws ScriptException {
        String fileName = "spring.log";
        if (args != null && args.length >= 2 && args[1] != null) {
            String absolutePath = args[1].replaceAll("\\\\", "/");
            String newPath = absolutePath.substring(0, absolutePath.lastIndexOf("/")) + "/" + fileName;
            return new File(newPath);
        }
        return new File(fileName);
    }

    private static void initSpring(File logfile) throws ScriptException {
        PrintStream old = System.out;
        PrintStream newlog = null;
        if (logfile.exists()) {
            logfile.delete();
        }
        try {
            newlog = new PrintStream(logfile);
            System.setOut(newlog);
            Runner.init((String)"/application.xml", null);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            System.setOut(old);
            if (newlog != null) {
                newlog.close();
            }
        }
    }
}

