/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.expression;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.expression.BooleanConverter;
import org.tinygroup.tinyscript.expression.Converter;
import org.tinygroup.tinyscript.expression.InExpressionProcessor;
import org.tinygroup.tinyscript.expression.IteratorConverter;
import org.tinygroup.tinyscript.expression.NumberCalculator;
import org.tinygroup.tinyscript.expression.Operator;
import org.tinygroup.tinyscript.expression.OperatorWithContext;
import org.tinygroup.tinyscript.expression.RangeOperator;
import org.tinygroup.tinyscript.expression.booleanconvert.ArrayBooleanConverter;
import org.tinygroup.tinyscript.expression.booleanconvert.CollectionBooleanConverter;
import org.tinygroup.tinyscript.expression.booleanconvert.EnumeratorBooleanConverter;
import org.tinygroup.tinyscript.expression.booleanconvert.IteratorBooleanConverter;
import org.tinygroup.tinyscript.expression.booleanconvert.MapBooleanConverter;
import org.tinygroup.tinyscript.expression.booleanconvert.StringBooleanConverter;
import org.tinygroup.tinyscript.expression.calculator.AvgCalculator;
import org.tinygroup.tinyscript.expression.calculator.CountAllCalculator;
import org.tinygroup.tinyscript.expression.calculator.CountCalculator;
import org.tinygroup.tinyscript.expression.calculator.DistinctCalculator;
import org.tinygroup.tinyscript.expression.calculator.MaxCalculator;
import org.tinygroup.tinyscript.expression.calculator.MedianCalculator;
import org.tinygroup.tinyscript.expression.calculator.MinCalculator;
import org.tinygroup.tinyscript.expression.calculator.PercentileCalculator;
import org.tinygroup.tinyscript.expression.calculator.RangeCalculator;
import org.tinygroup.tinyscript.expression.calculator.SampleStdevpCalculator;
import org.tinygroup.tinyscript.expression.calculator.SampleVarianceCalculator;
import org.tinygroup.tinyscript.expression.calculator.StandardDeviationCalculator;
import org.tinygroup.tinyscript.expression.calculator.SumCalculator;
import org.tinygroup.tinyscript.expression.calculator.VarianceCalculator;
import org.tinygroup.tinyscript.expression.convert.BigDecimalDouble;
import org.tinygroup.tinyscript.expression.convert.BigDecimalFloat;
import org.tinygroup.tinyscript.expression.convert.BigDecimalInteger;
import org.tinygroup.tinyscript.expression.convert.BigDecimalLong;
import org.tinygroup.tinyscript.expression.convert.ByteBigDecimal;
import org.tinygroup.tinyscript.expression.convert.ByteCharacter;
import org.tinygroup.tinyscript.expression.convert.ByteDouble;
import org.tinygroup.tinyscript.expression.convert.ByteFloat;
import org.tinygroup.tinyscript.expression.convert.ByteInteger;
import org.tinygroup.tinyscript.expression.convert.CharacterBigDecimal;
import org.tinygroup.tinyscript.expression.convert.CharacterDouble;
import org.tinygroup.tinyscript.expression.convert.CharacterFloat;
import org.tinygroup.tinyscript.expression.convert.CharacterInteger;
import org.tinygroup.tinyscript.expression.convert.DoubleBigDecimal;
import org.tinygroup.tinyscript.expression.convert.DoubleFloat;
import org.tinygroup.tinyscript.expression.convert.DoubleInteger;
import org.tinygroup.tinyscript.expression.convert.DoubleLong;
import org.tinygroup.tinyscript.expression.convert.FloatBigDecimal;
import org.tinygroup.tinyscript.expression.convert.FloatDouble;
import org.tinygroup.tinyscript.expression.convert.FloatInteger;
import org.tinygroup.tinyscript.expression.convert.FloatLong;
import org.tinygroup.tinyscript.expression.convert.IntegerBigDecimal;
import org.tinygroup.tinyscript.expression.convert.IntegerDouble;
import org.tinygroup.tinyscript.expression.convert.IntegerFloat;
import org.tinygroup.tinyscript.expression.convert.IntegerLong;
import org.tinygroup.tinyscript.expression.convert.LongBigDecimal;
import org.tinygroup.tinyscript.expression.convert.LongDouble;
import org.tinygroup.tinyscript.expression.convert.LongFloat;
import org.tinygroup.tinyscript.expression.convert.LongInteger;
import org.tinygroup.tinyscript.expression.convert.StringBigDecimal;
import org.tinygroup.tinyscript.expression.convert.StringDouble;
import org.tinygroup.tinyscript.expression.convert.StringFloat;
import org.tinygroup.tinyscript.expression.convert.StringInteger;
import org.tinygroup.tinyscript.expression.convert.StringLong;
import org.tinygroup.tinyscript.expression.in.ArrayInProcessor;
import org.tinygroup.tinyscript.expression.in.CollectionInProcessor;
import org.tinygroup.tinyscript.expression.in.MapInProcessor;
import org.tinygroup.tinyscript.expression.iteratorconvert.ArrayIteratorConverter;
import org.tinygroup.tinyscript.expression.iteratorconvert.CollectionIteratorConverter;
import org.tinygroup.tinyscript.expression.iteratorconvert.MapIteratorConverter;
import org.tinygroup.tinyscript.expression.iteratorconvert.StringIteratorConverter;
import org.tinygroup.tinyscript.expression.operator.AdOperator;
import org.tinygroup.tinyscript.expression.operator.AddOperator;
import org.tinygroup.tinyscript.expression.operator.AndLogicOperator;
import org.tinygroup.tinyscript.expression.operator.BigEqualsOperator;
import org.tinygroup.tinyscript.expression.operator.BigOperator;
import org.tinygroup.tinyscript.expression.operator.ComplementOperator;
import org.tinygroup.tinyscript.expression.operator.ComplexOperator;
import org.tinygroup.tinyscript.expression.operator.DevideOperator;
import org.tinygroup.tinyscript.expression.operator.EqualsOperator;
import org.tinygroup.tinyscript.expression.operator.LeftAddOperator;
import org.tinygroup.tinyscript.expression.operator.LeftLiteralOperator;
import org.tinygroup.tinyscript.expression.operator.LeftNotOperator;
import org.tinygroup.tinyscript.expression.operator.LeftPlusPlusOperator;
import org.tinygroup.tinyscript.expression.operator.LeftSubtractOperator;
import org.tinygroup.tinyscript.expression.operator.LeftSubtractSubtractOperator;
import org.tinygroup.tinyscript.expression.operator.LessEqualsOperator;
import org.tinygroup.tinyscript.expression.operator.LessOperator;
import org.tinygroup.tinyscript.expression.operator.ModOperator;
import org.tinygroup.tinyscript.expression.operator.MultiplyOperator;
import org.tinygroup.tinyscript.expression.operator.NotEqualsOperator;
import org.tinygroup.tinyscript.expression.operator.OrLogicOperator;
import org.tinygroup.tinyscript.expression.operator.OrOperator;
import org.tinygroup.tinyscript.expression.operator.RightPlusPlusOperator;
import org.tinygroup.tinyscript.expression.operator.RightSubtractSubtractOperator;
import org.tinygroup.tinyscript.expression.operator.ShlOperator;
import org.tinygroup.tinyscript.expression.operator.Shr2Operator;
import org.tinygroup.tinyscript.expression.operator.ShrOperator;
import org.tinygroup.tinyscript.expression.operator.SimpleConditionOperator;
import org.tinygroup.tinyscript.expression.operator.SubtractOperator;
import org.tinygroup.tinyscript.expression.operator.XorOperator;
import org.tinygroup.tinyscript.expression.range.CharRangeOperator;
import org.tinygroup.tinyscript.expression.range.IntegerRangeOperator;
import org.tinygroup.tinyscript.expression.range.LongRangeOperator;
import org.tinygroup.tinyscript.expression.range.NumberRangeOperator;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public final class ExpressionUtil {
    private static Map<String, ComplexOperator> operationMap = new HashMap<String, ComplexOperator>();
    private static Map<String, OperatorWithContext> operationWithContextMap = new HashMap<String, OperatorWithContext>();
    private static Converter[][] converters = new Converter[8][8];
    private static Map<Class, Integer> typeMap = new HashMap<Class, Integer>();
    private static List<BooleanConverter> booleanConverters = new ArrayList<BooleanConverter>();
    private static List<IteratorConverter> iteratorConverters = new ArrayList<IteratorConverter>();
    private static Map<String, NumberCalculator> numberCalculatorMap = new HashMap<String, NumberCalculator>();
    private static List<RangeOperator> rangeOperators = new ArrayList<RangeOperator>();
    private static List<InExpressionProcessor> inProcessors = new ArrayList<InExpressionProcessor>();

    private ExpressionUtil() {
    }

    public static Object convert(Object object, Class<?> sourceType, Class<?> destType) {
        return converters[typeMap.get(sourceType)][typeMap.get(destType)].convert(object);
    }

    public static void addInProcessor(InExpressionProcessor inProcessor) {
        inProcessors.add(inProcessor);
    }

    public static Object convert(Object value, Class<?> destType) throws ScriptException {
        try {
            if (value == null || value.getClass() == destType) {
                return value;
            }
            return ExpressionUtil.convert(value, value.getClass(), destType);
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("number.convert.error", value.getClass().getName(), destType.getName()), e);
        }
    }

    public static Double convertDouble(Object value) throws ScriptException {
        return (Double)ExpressionUtil.convert(value, Double.class);
    }

    public static Long convertLong(Object value) throws ScriptException {
        return (Long)ExpressionUtil.convert(value, Long.class);
    }

    public static Float convertFloat(Object value) throws ScriptException {
        return (Float)ExpressionUtil.convert(value, Float.class);
    }

    public static Integer convertInteger(Object value) throws ScriptException {
        return (Integer)ExpressionUtil.convert(value, Integer.class);
    }

    public static int compare(Class<?> type1, Class<?> type2) {
        int index2;
        int index1 = typeMap.get(type1);
        if (index1 == (index2 = typeMap.get(type2).intValue())) {
            return 0;
        }
        if (index1 > index2) {
            return 1;
        }
        return -1;
    }

    public static boolean isNumber(Class<?> type) {
        return typeMap.containsKey(type) && type != String.class;
    }

    public static void addConverter(Converter converter) {
        ExpressionUtil.converters[ExpressionUtil.typeMap.get(converter.getSourceType()).intValue()][ExpressionUtil.typeMap.get(converter.getDestType()).intValue()] = converter;
    }

    public static void addOperator(Operator operator) {
        ComplexOperator complexOperator = operationMap.get(operator.getOperation());
        if (complexOperator != null) {
            complexOperator.addOperator(operator);
        } else {
            complexOperator = new ComplexOperator(operator);
            operationMap.put(complexOperator.getOperation(), complexOperator);
        }
    }

    public static void addOperator(OperatorWithContext operator) {
        operationWithContextMap.put(operator.getOperation(), operator);
    }

    public static void addBooleanConverter(BooleanConverter converter) {
        for (BooleanConverter oldBooleanConverter : booleanConverters) {
            if (!oldBooleanConverter.equals(converter) && !oldBooleanConverter.getClass().isInstance(converter)) continue;
            return;
        }
        booleanConverters.add(converter);
    }

    public static void addIteratorConverter(IteratorConverter converter) {
        for (IteratorConverter oldIteratorConverter : iteratorConverters) {
            if (!oldIteratorConverter.equals(converter) && !oldIteratorConverter.getClass().isInstance(converter)) continue;
            return;
        }
        iteratorConverters.add(converter);
    }

    public static Object executeOperation(String op, Object ... parameters) throws ScriptException {
        Operator operator = operationMap.get(op);
        if (operator == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("op.notfound.error", op));
        }
        return operator.operation(parameters);
    }

    public static Object executeOperationWithContext(ScriptContext context, String op, String name, Object value) throws ScriptException {
        OperatorWithContext operator = operationWithContextMap.get(op);
        if (operator == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("op.notfound.error", op));
        }
        return operator.operation(context, name, value);
    }

    public static boolean getBooleanValue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        for (BooleanConverter converter : booleanConverters) {
            if (!converter.isMatch(object)) continue;
            return (Boolean)converter.convert(object);
        }
        return true;
    }

    public static Iterator getIterator(Object object) {
        if (object != null) {
            if (object instanceof Iterator) {
                return (Iterator)object;
            }
            for (IteratorConverter converter : iteratorConverters) {
                if (!converter.isMatch(object)) continue;
                return (Iterator)converter.convert(object);
            }
        }
        return null;
    }

    public static int compareNumber(Comparable c1, Comparable c2) {
        Class<?> t2;
        Class<?> t1 = c1.getClass();
        if (!t1.equals(t2 = c2.getClass())) {
            Comparable leftObject = c1;
            Comparable rightObject = c2;
            if (ExpressionUtil.compare(t1, t2) > 0) {
                rightObject = (Comparable)ExpressionUtil.convert(rightObject, t2, t1);
            } else {
                leftObject = (Comparable)ExpressionUtil.convert(leftObject, t1, t2);
            }
            return leftObject.compareTo(rightObject);
        }
        return c1.compareTo(c2);
    }

    public static void addNumberCalculator(NumberCalculator numberCalculator) {
        numberCalculatorMap.put(numberCalculator.getName(), numberCalculator);
    }

    public static NumberCalculator getNumberCalculator(String name) {
        return numberCalculatorMap.get(name);
    }

    public static List<String> getCalculatorNames() {
        return new ArrayList<String>(numberCalculatorMap.keySet());
    }

    public static Object compute(String name, List<Object> numbers, Object ... params) throws ScriptException {
        NumberCalculator numberCalculator = numberCalculatorMap.get(name);
        if (numberCalculator == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("calculator.notfound.error", name));
        }
        if (numbers == null || numbers.isEmpty()) {
            return numberCalculator.getEmptyValue();
        }
        return numberCalculator.compute(numbers, params);
    }

    public static boolean containsCollection(List<Object> numbers) {
        for (Object number : numbers) {
            if (!ExpressionUtil.isCollection(number)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCollection(Object object) {
        if (object.getClass().isArray()) {
            return true;
        }
        if (object instanceof Collection) {
            return true;
        }
        return object instanceof Map;
    }

    public static List<Object> convertCollection(Object object) {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object v = Array.get(object, i);
                if (v == null) continue;
                parameterList.add(v);
            }
        } else if (object instanceof Collection) {
            parameterList.addAll((Collection)object);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            parameterList.addAll(map.values());
        }
        return parameterList;
    }

    public static List<List<Object>> splitCollection(List<Object> numbers) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        ArrayList<Object> tempList = null;
        for (Object number : numbers) {
            if (ExpressionUtil.isCollection(number)) {
                if (tempList != null) {
                    result.add(tempList);
                    tempList = null;
                }
                result.add(ExpressionUtil.convertCollection(number));
                continue;
            }
            if (tempList == null) {
                tempList = new ArrayList<Object>();
            }
            tempList.add(number);
        }
        if (tempList != null) {
            result.add(tempList);
        }
        return result;
    }

    public static void addRangeOperator(RangeOperator operator) {
        for (RangeOperator rangeOperator : rangeOperators) {
            if (!rangeOperator.equals(operator) && !rangeOperator.getClass().isInstance(operator)) continue;
            return;
        }
        rangeOperators.add(operator);
    }

    public static List<Object> createRange(Object start, Object end) throws ScriptException {
        if (start == null || end == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("range.empty.error"));
        }
        for (RangeOperator rangeOperator : rangeOperators) {
            if (!rangeOperator.isMatch(start, end)) continue;
            return rangeOperator.createRange(start, end);
        }
        return null;
    }

    public static boolean in(Object collection, Object item) throws Exception {
        for (InExpressionProcessor inProcessor : inProcessors) {
            if (!inProcessor.isMatch(collection)) continue;
            return inProcessor.checkIn(collection, item);
        }
        return false;
    }

    static {
        typeMap.put(Byte.class, 0);
        typeMap.put(Character.class, 1);
        typeMap.put(Integer.class, 2);
        typeMap.put(Long.class, 3);
        typeMap.put(Float.class, 4);
        typeMap.put(Double.class, 5);
        typeMap.put(BigDecimal.class, 6);
        typeMap.put(String.class, 7);
        ExpressionUtil.addConverter(new ByteCharacter());
        ExpressionUtil.addConverter(new ByteInteger());
        ExpressionUtil.addConverter(new ByteFloat());
        ExpressionUtil.addConverter(new ByteDouble());
        ExpressionUtil.addConverter(new ByteBigDecimal());
        ExpressionUtil.addConverter(new CharacterInteger());
        ExpressionUtil.addConverter(new CharacterFloat());
        ExpressionUtil.addConverter(new CharacterDouble());
        ExpressionUtil.addConverter(new CharacterBigDecimal());
        ExpressionUtil.addConverter(new IntegerLong());
        ExpressionUtil.addConverter(new IntegerFloat());
        ExpressionUtil.addConverter(new IntegerDouble());
        ExpressionUtil.addConverter(new IntegerBigDecimal());
        ExpressionUtil.addConverter(new LongFloat());
        ExpressionUtil.addConverter(new LongDouble());
        ExpressionUtil.addConverter(new LongInteger());
        ExpressionUtil.addConverter(new LongBigDecimal());
        ExpressionUtil.addConverter(new FloatDouble());
        ExpressionUtil.addConverter(new FloatInteger());
        ExpressionUtil.addConverter(new FloatLong());
        ExpressionUtil.addConverter(new FloatBigDecimal());
        ExpressionUtil.addConverter(new DoubleBigDecimal());
        ExpressionUtil.addConverter(new DoubleInteger());
        ExpressionUtil.addConverter(new DoubleLong());
        ExpressionUtil.addConverter(new DoubleFloat());
        ExpressionUtil.addConverter(new StringBigDecimal());
        ExpressionUtil.addConverter(new StringInteger());
        ExpressionUtil.addConverter(new StringLong());
        ExpressionUtil.addConverter(new StringFloat());
        ExpressionUtil.addConverter(new StringDouble());
        ExpressionUtil.addConverter(new BigDecimalDouble());
        ExpressionUtil.addConverter(new BigDecimalFloat());
        ExpressionUtil.addConverter(new BigDecimalInteger());
        ExpressionUtil.addConverter(new BigDecimalLong());
        ExpressionUtil.addOperator(new AddOperator());
        ExpressionUtil.addOperator(new SubtractOperator());
        ExpressionUtil.addOperator(new MultiplyOperator());
        ExpressionUtil.addOperator(new DevideOperator());
        ExpressionUtil.addOperator(new XorOperator());
        ExpressionUtil.addOperator(new AdOperator());
        ExpressionUtil.addOperator(new OrOperator());
        ExpressionUtil.addOperator(new ModOperator());
        ExpressionUtil.addOperator(new SimpleConditionOperator());
        ExpressionUtil.addOperator(new LeftAddOperator());
        ExpressionUtil.addOperator(new LeftSubtractOperator());
        ExpressionUtil.addOperator(new LeftPlusPlusOperator());
        ExpressionUtil.addOperator(new LeftSubtractSubtractOperator());
        ExpressionUtil.addOperator(new RightPlusPlusOperator());
        ExpressionUtil.addOperator(new RightSubtractSubtractOperator());
        ExpressionUtil.addOperator(new LeftLiteralOperator());
        ExpressionUtil.addOperator(new ComplementOperator());
        ExpressionUtil.addOperator(new LeftNotOperator());
        ExpressionUtil.addOperator(new AndLogicOperator());
        ExpressionUtil.addOperator(new OrLogicOperator());
        ExpressionUtil.addOperator(new EqualsOperator());
        ExpressionUtil.addOperator(new NotEqualsOperator());
        ExpressionUtil.addOperator(new LessEqualsOperator());
        ExpressionUtil.addOperator(new LessOperator());
        ExpressionUtil.addOperator(new BigOperator());
        ExpressionUtil.addOperator(new BigEqualsOperator());
        ExpressionUtil.addOperator(new ShlOperator());
        ExpressionUtil.addOperator(new ShrOperator());
        ExpressionUtil.addOperator(new Shr2Operator());
        ExpressionUtil.addBooleanConverter(new StringBooleanConverter());
        ExpressionUtil.addBooleanConverter(new CollectionBooleanConverter());
        ExpressionUtil.addBooleanConverter(new ArrayBooleanConverter());
        ExpressionUtil.addBooleanConverter(new IteratorBooleanConverter());
        ExpressionUtil.addBooleanConverter(new EnumeratorBooleanConverter());
        ExpressionUtil.addBooleanConverter(new MapBooleanConverter());
        ExpressionUtil.addIteratorConverter(new StringIteratorConverter());
        ExpressionUtil.addIteratorConverter(new CollectionIteratorConverter());
        ExpressionUtil.addIteratorConverter(new MapIteratorConverter());
        ExpressionUtil.addIteratorConverter(new ArrayIteratorConverter());
        ExpressionUtil.addNumberCalculator(new AvgCalculator());
        ExpressionUtil.addNumberCalculator(new MaxCalculator());
        ExpressionUtil.addNumberCalculator(new MinCalculator());
        ExpressionUtil.addNumberCalculator(new MedianCalculator());
        ExpressionUtil.addNumberCalculator(new RangeCalculator());
        ExpressionUtil.addNumberCalculator(new StandardDeviationCalculator());
        ExpressionUtil.addNumberCalculator(new SumCalculator());
        ExpressionUtil.addNumberCalculator(new VarianceCalculator());
        ExpressionUtil.addNumberCalculator(new CountCalculator());
        ExpressionUtil.addNumberCalculator(new DistinctCalculator());
        ExpressionUtil.addNumberCalculator(new SampleVarianceCalculator());
        ExpressionUtil.addNumberCalculator(new SampleStdevpCalculator());
        ExpressionUtil.addNumberCalculator(new PercentileCalculator());
        ExpressionUtil.addNumberCalculator(new CountAllCalculator());
        ExpressionUtil.addRangeOperator(new IntegerRangeOperator());
        ExpressionUtil.addRangeOperator(new LongRangeOperator());
        ExpressionUtil.addRangeOperator(new NumberRangeOperator());
        ExpressionUtil.addRangeOperator(new CharRangeOperator());
        ExpressionUtil.addInProcessor(new ArrayInProcessor());
        ExpressionUtil.addInProcessor(new CollectionInProcessor());
        ExpressionUtil.addInProcessor(new MapInProcessor());
    }
}

