/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.expression.TypeConvertProcessor;
import org.tinygroup.tinyscript.expression.typeconvert.BooleanTypeConvertProcessor;
import org.tinygroup.tinyscript.expression.typeconvert.CharTypeConvertProcessor;
import org.tinygroup.tinyscript.expression.typeconvert.DateTypeConvertProcessor;
import org.tinygroup.tinyscript.expression.typeconvert.DoubleTypeConvertProcessor;
import org.tinygroup.tinyscript.expression.typeconvert.FloatTypeConvertProcessor;
import org.tinygroup.tinyscript.expression.typeconvert.IntegerTypeConvertProcessor;
import org.tinygroup.tinyscript.expression.typeconvert.LongTypeConvertProcessor;
import org.tinygroup.tinyscript.expression.typeconvert.ShortTypeConvertProcessor;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public final class TypeConvertUtil {
    private static Map<String, TypeConvertProcessor> processorMap = new HashMap<String, TypeConvertProcessor>();

    private TypeConvertUtil() {
    }

    public static void addTypeConvertProcessor(TypeConvertProcessor processor) {
        processorMap.put(processor.getName(), processor);
    }

    public static void removeTypeConvertProcessor(TypeConvertProcessor processor) {
        processorMap.remove(processor.getName());
    }

    public static boolean exsitType(String type) {
        return processorMap.containsKey(type);
    }

    public static List<String> getTypes() {
        return new ArrayList<String>(processorMap.keySet());
    }

    public static Object convert(String type, Object ... parameters) throws Exception {
        TypeConvertProcessor processor = processorMap.get(type);
        if (processor == null) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("type.convert.error", type));
        }
        return processor.convert(parameters);
    }

    static {
        TypeConvertUtil.addTypeConvertProcessor(new IntegerTypeConvertProcessor());
        TypeConvertUtil.addTypeConvertProcessor(new LongTypeConvertProcessor());
        TypeConvertUtil.addTypeConvertProcessor(new FloatTypeConvertProcessor());
        TypeConvertUtil.addTypeConvertProcessor(new DoubleTypeConvertProcessor());
        TypeConvertUtil.addTypeConvertProcessor(new DateTypeConvertProcessor());
        TypeConvertUtil.addTypeConvertProcessor(new BooleanTypeConvertProcessor());
        TypeConvertUtil.addTypeConvertProcessor(new ShortTypeConvertProcessor());
        TypeConvertUtil.addTypeConvertProcessor(new CharTypeConvertProcessor());
    }
}

