/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.expression.calculator;

import java.util.Collections;
import java.util.List;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.expression.calculator.CollectionNumberCalculator;

public class PercentileCalculator
extends CollectionNumberCalculator {
    @Override
    public String getName() {
        return "percentile";
    }

    @Override
    public Object computeItem(List<Object> numbers, Object ... params) throws ScriptException {
        List<Object> list = numbers;
        Collections.sort(list);
        double percent = Double.parseDouble(params[0] + "") * (double)(numbers.size() - 1);
        int pos = (int)Math.floor(percent);
        if ((double)pos - percent == 0.0) {
            return numbers.get(pos);
        }
        return (1.0 - (percent - (double)pos)) * ExpressionUtil.convertDouble(numbers.get(pos)) + (percent - (double)pos) * ExpressionUtil.convertDouble(numbers.get(pos + 1));
    }
}

