/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.expression.calculator;

import java.util.List;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.expression.calculator.CollectionNumberCalculator;

public class RangeCalculator
extends CollectionNumberCalculator {
    @Override
    public String getName() {
        return "range";
    }

    @Override
    public Object computeItem(List<Object> numbers, Object ... params) throws ScriptException {
        if (numbers.size() == 1) {
            return ExpressionUtil.executeOperation("-", numbers.get(0), numbers.get(0));
        }
        Comparable max = (Comparable)numbers.get(0);
        Comparable min = (Comparable)numbers.get(0);
        for (int i = 1; i < numbers.size(); ++i) {
            Comparable item = (Comparable)numbers.get(i);
            if (ExpressionUtil.compareNumber(item, max) > 0) {
                max = item;
            }
            if (ExpressionUtil.compareNumber(item, min) >= 0) continue;
            min = item;
        }
        return ExpressionUtil.executeOperation("-", max, min);
    }
}

