/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.expression.calculator;

import java.util.List;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.expression.calculator.CollectionNumberCalculator;

public class StandardDeviationCalculator
extends CollectionNumberCalculator {
    @Override
    public String getName() {
        return "stdevp";
    }

    @Override
    public Object computeItem(List<Object> numbers, Object ... params) throws ScriptException {
        if (numbers.size() == 1) {
            return 0.0;
        }
        double total = 0.0;
        for (Object obj : numbers) {
            total += ExpressionUtil.convertDouble(obj).doubleValue();
        }
        double avg = total / (double)numbers.size();
        total = 0.0;
        for (Object obj : numbers) {
            double temp = ExpressionUtil.convertDouble(obj) - avg;
            total += temp * temp;
        }
        return Math.sqrt(total / (double)numbers.size());
    }
}

