/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.expression.operator;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.tinyscript.ScriptCollectionModel;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.collection.CollectionModelUtil;
import org.tinygroup.tinyscript.expression.Operator;
import org.tinygroup.tinyscript.expression.operator.AbstractOperator;

public final class ComplexOperator
extends AbstractOperator {
    private List<Operator> operatorList = new ArrayList<Operator>();
    private Operator defaultOperator;

    public ComplexOperator(Operator operator) {
        this.defaultOperator = operator;
    }

    public void addOperator(Operator operator) {
        for (Operator oldOperator : this.operatorList) {
            if (!oldOperator.equals(operator) && !oldOperator.getClass().isInstance(operator)) continue;
            return;
        }
        this.operatorList.add(operator);
    }

    public void removeOperator(Operator operator) {
        this.operatorList.remove(operator);
    }

    @Override
    public Object operation(Object ... parameter) throws ScriptException {
        ScriptCollectionModel model;
        if (!this.operatorList.isEmpty()) {
            for (Operator operator : this.operatorList) {
                if (!operator.isMatch(parameter)) continue;
                return operator.operation(parameter);
            }
        }
        if (this.defaultOperator.supportCollection() && parameter != null && parameter.length > 0 && (model = CollectionModelUtil.getScriptCollectionModel(parameter[0])) != null) {
            return model.executeOperator(this.getOperation(), parameter);
        }
        return this.defaultOperator.operation(parameter);
    }

    @Override
    public String getOperation() {
        return this.defaultOperator.getOperation();
    }

    @Override
    public int getParameterCount() {
        return this.defaultOperator.getParameterCount();
    }
}

