/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.expression.typeconvert;

import java.util.Calendar;
import java.util.Date;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.expression.TypeConvertProcessor;
import org.tinygroup.tinyscript.function.date.DateUtil;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public class DateTypeConvertProcessor
implements TypeConvertProcessor {
    @Override
    public String getName() {
        return "date";
    }

    @Override
    public Object convert(Object ... parameters) throws Exception {
        if (parameters != null) {
            if (parameters.length == 1) {
                return this.convertDate(parameters[0], null);
            }
            if (parameters.length == 2) {
                if (parameters[1] instanceof String) {
                    return this.convertDate(parameters[0], (String)parameters[1]);
                }
                if (parameters[1] instanceof Object[]) {
                    return this.convertDate(parameters[0], (String)((Object[])parameters[1])[0]);
                }
            }
        }
        return null;
    }

    protected Date convertDate(Object obj, String rule) throws Exception {
        if (obj instanceof String) {
            return DateUtil.convertDateByString((String)obj, rule);
        }
        if (obj instanceof Long) {
            return new Date((Long)obj);
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTime();
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("number.convert.error", obj.getClass().getName(), Date.class.getName()));
    }
}

