/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.fileresolver;

import java.io.InputStream;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.tinyscript.ScriptEngine;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptUtil;
import org.tinygroup.vfs.FileObject;

public class ScriptSegmentFileProcessor
extends AbstractFileProcessor {
    private ScriptEngine scriptEngine;

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void process() {
        ScriptSegment segment;
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("fileprocessor.load.start", fileObject.getAbsolutePath()));
            segment = this.loadScriptSegment(fileObject);
            if (segment != null) {
                this.scriptEngine.addScriptSegment(segment);
                LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("fileprocessor.loading", segment.getSegmentId()));
            }
            LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("fileprocessor.load.end", fileObject.getAbsolutePath()));
        }
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("fileprocessor.delete.start", fileObject.getAbsolutePath()));
            segment = this.loadScriptSegment(fileObject);
            if (segment != null) {
                this.scriptEngine.removeScriptSegment(segment);
                LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("fileprocessor.deleting", segment.getSegmentId()));
            }
            LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("fileprocessor.delete.end", fileObject.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ScriptSegment loadScriptSegment(FileObject fileObject) {
        InputStream inputStream = null;
        inputStream = fileObject.getInputStream();
        String text = FileUtil.readStreamContent((InputStream)inputStream, (String)this.scriptEngine.getEncode());
        ScriptSegment scriptSegment = ScriptUtil.getDefault().createScriptSegment(this.scriptEngine, null, text);
        if (inputStream == null) return scriptSegment;
        try {
            inputStream.close();
            return scriptSegment;
        }
        catch (Exception e) {
            LOGGER.errorMessage(ResourceBundleUtil.getDefaultMessage("close.file.error", fileObject.getAbsolutePath()), (Throwable)e, new Object[0]);
        }
        return scriptSegment;
        catch (Exception e) {
            try {
                LOGGER.errorMessage(ResourceBundleUtil.getDefaultMessage("fileprocessor.load.error", fileObject.getAbsolutePath()), (Throwable)e, new Object[0]);
                if (inputStream == null) return null;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    LOGGER.errorMessage(ResourceBundleUtil.getDefaultMessage("close.file.error", fileObject.getAbsolutePath()), (Throwable)e2, new Object[0]);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return null;
            }
            catch (Exception e3) {
                LOGGER.errorMessage(ResourceBundleUtil.getDefaultMessage("close.file.error", fileObject.getAbsolutePath()), (Throwable)e3, new Object[0]);
            }
            return null;
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(".tsf");
    }
}

