/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.fileresolver;

import java.io.InputStream;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.tinyscript.ScriptEngine;
import org.tinygroup.tinyscript.ScriptEngineFactory;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.ScriptUtil;
import org.tinygroup.vfs.FileObject;

public class ScriptSegmentModuleProcessor
extends AbstractFileProcessor {
    private ScriptEngine scriptEngine;
    private String[] moduleNames;
    private static final String[] DEFALUT_MODULE_NAMES = new String[]{"service", "dao"};

    public ScriptEngine getScriptEngine() {
        if (this.scriptEngine == null) {
            try {
                this.scriptEngine = ScriptEngineFactory.createByBean();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.scriptEngine;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public String[] getModules() {
        if (this.moduleNames == null) {
            String scriptModuleName = ConfigurationUtil.getConfigurationManager().getConfiguration("scriptModuleName");
            this.moduleNames = StringUtil.isEmpty((String)scriptModuleName) ? DEFALUT_MODULE_NAMES : scriptModuleName.split(",");
        }
        return this.moduleNames;
    }

    public void process() {
        ScriptSegment segment;
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("moduleprocessor.load.start", fileObject.getAbsolutePath()));
            segment = this.loadScriptSegment(fileObject);
            if (segment != null) {
                this.getScriptEngine().addScriptSegment(segment);
                LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("moduleprocessor.loading", segment.getSegmentId()));
            }
            LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("moduleprocessor.load.end", fileObject.getAbsolutePath()));
        }
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("moduleprocessor.delete.start", fileObject.getAbsolutePath()));
            segment = this.loadScriptSegment(fileObject);
            if (segment != null) {
                this.getScriptEngine().removeScriptSegment(segment);
                LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("moduleprocessor.deleting", segment.getSegmentId()));
            }
            LOGGER.logMessage(LogLevel.INFO, ResourceBundleUtil.getDefaultMessage("moduleprocessor.delete.end", fileObject.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ScriptSegment loadScriptSegment(FileObject fileObject) {
        InputStream inputStream = null;
        inputStream = fileObject.getInputStream();
        String text = FileUtil.readStreamContent((InputStream)inputStream, (String)this.getScriptEngine().getEncode());
        ScriptSegment scriptSegment = ScriptUtil.getDefault().createScriptSegment(this.getScriptEngine(), null, text);
        if (inputStream == null) return scriptSegment;
        try {
            inputStream.close();
            return scriptSegment;
        }
        catch (Exception e) {
            LOGGER.errorMessage(ResourceBundleUtil.getDefaultMessage("close.file.error", fileObject.getAbsolutePath()), (Throwable)e, new Object[0]);
        }
        return scriptSegment;
        catch (Exception e) {
            try {
                LOGGER.errorMessage(ResourceBundleUtil.getDefaultMessage("moduleprocessor.load.error", fileObject.getAbsolutePath()), (Throwable)e, new Object[0]);
                if (inputStream == null) return null;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    LOGGER.errorMessage(ResourceBundleUtil.getDefaultMessage("close.file.error", fileObject.getAbsolutePath()), (Throwable)e2, new Object[0]);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return null;
            }
            catch (Exception e3) {
                LOGGER.errorMessage(ResourceBundleUtil.getDefaultMessage("close.file.error", fileObject.getAbsolutePath()), (Throwable)e3, new Object[0]);
            }
            return null;
        }
    }

    protected boolean checkMatch(FileObject fileObject) {
        String name = fileObject.getFileName();
        if (name.endsWith(".tsf")) {
            String[] modules;
            for (String module : modules = this.getModules()) {
                if (StringUtil.isEmpty((String)module) || !name.endsWith("." + module + ".tsf")) continue;
                return true;
            }
        }
        return false;
    }
}

