/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.function.DynamicNameScriptFunction;
import org.tinygroup.tinyscript.interpret.LambdaFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public abstract class AbstractDpKnapsackFunction
extends DynamicNameScriptFunction {
    @Override
    public boolean exsitFunctionName(String name) {
        return name.equals("dpKnapsack");
    }

    @Override
    public List<String> getFunctionNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("dpKnapsack");
        return names;
    }

    public List<Object> dpKnapsackResult(int[] weight, double[] value, int bagSize, int[] maxCount, Object ... parameters) throws Exception {
        double[][] result = new double[weight.length][bagSize + 1];
        this.dpKnapsackResult(result, weight.length - 1, bagSize, weight, maxCount, value, parameters);
        Integer[] items = new Integer[weight.length];
        this.findResult(weight.length - 1, bagSize, result, weight, value, maxCount, items);
        ArrayList<Object> list = new ArrayList<Object>();
        Collections.addAll(list, items);
        list.set(0, result[weight.length - 1][bagSize]);
        return list;
    }

    private void dpKnapsackResult(double[][] result, int types, int bagSize, int[] weight, int[] maxCount, double[] value, Object ... parameters) throws Exception {
        int i;
        ScriptContext context = null;
        LambdaFunction pruneFunction = null;
        if (parameters.length > 0) {
            context = (ScriptContext)parameters[1];
            context.getParent().put("resultArray", (Object)result);
            pruneFunction = (LambdaFunction)parameters[2];
        }
        for (i = 0; i <= types; ++i) {
            result[i][0] = 0.0;
        }
        for (int v = 0; v <= bagSize; ++v) {
            result[0][v] = 0.0;
        }
        for (i = 1; i <= types; ++i) {
            for (int v = weight[i]; v <= bagSize; ++v) {
                result[i][v] = 0.0;
                int nCount = Math.min(maxCount[i], v / weight[i]);
                for (int k = 0; k <= nCount; ++k) {
                    if (context != null) {
                        context.put("i", (Boolean)context.get("isIndexFromOne") != false ? i : i - 1);
                        context.put("v", v);
                        context.put("k", k);
                    }
                    if (parameters.length > 0) {
                        if (!this.executePrune(pruneFunction, context)) continue;
                        result[i][v] = Math.max(result[i][v], result[i - 1][v - k * weight[i]] + (double)k * value[i]);
                        continue;
                    }
                    result[i][v] = Math.max(result[i][v], result[i - 1][v - k * weight[i]] + (double)k * value[i]);
                }
            }
        }
    }

    protected void findResult(int i, int j, double[][] f, int[] w, double[] v, int[] count, Integer[] items) {
        if (i > 0) {
            if (f[i][j] == f[i - 1][j]) {
                items[i] = 0;
                this.findResult(i - 1, j, f, w, v, count, items);
            } else if (j - w[i] >= 0) {
                int min = Math.min(j / w[i], count[i]);
                int temp = 0;
                for (int k = 1; k <= min; ++k) {
                    if (f[i - 1][j - k * w[i]] != f[i][j] - (double)k * v[i]) continue;
                    temp = k;
                    break;
                }
                items[i] = temp;
                this.findResult(i - 1, j - temp * w[i], f, w, v, count, items);
            }
        }
    }

    protected int[] getCount(Object obj, int[] weight, int size) throws ScriptException {
        Object maxCount = obj;
        if (obj == null || obj instanceof Integer && (Integer)obj == -1) {
            maxCount = new int[weight.length];
            for (int i = 1; i < ((int[])maxCount).length; ++i) {
                ((int[])maxCount)[i] = size / weight[i];
            }
        } else if (maxCount instanceof Integer) {
            int temp = (Integer)maxCount;
            maxCount = new int[weight.length];
            Arrays.fill((int[])maxCount, temp);
            ((int[])maxCount)[0] = 0;
        } else {
            maxCount = (int[])this.convertToArray(obj, Integer.TYPE);
            for (int i = 1; i < ((int[])maxCount).length; ++i) {
                if (((int[])maxCount)[i] != -1) continue;
                ((int[])maxCount)[i] = size / weight[i];
            }
        }
        return (int[])maxCount;
    }

    protected boolean executePrune(LambdaFunction pruneFunction, ScriptContext context) throws ScriptException {
        try {
            return (Boolean)pruneFunction.execute(context, new Object[0]).getResult();
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.run.error", this.getNames()), e);
        }
    }

    protected abstract List<Object> getLastResult(List<?> var1, Object var2) throws ScriptException;

    protected abstract Object convertToArray(Object var1, Class<?> var2) throws ScriptException;
}

