/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptEngine;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptFunction;
import org.tinygroup.tinyscript.config.FunctionConfig;
import org.tinygroup.tinyscript.config.ScriptFunctionConfig;
import org.tinygroup.tinyscript.interpret.ExpressionParameter;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;

public abstract class AbstractScriptFunction
implements ScriptFunction {
    private ScriptEngine scriptEngine;

    @Override
    public void setScriptEngine(ScriptEngine engine) {
        this.scriptEngine = engine;
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Override
    public boolean enableExpressionParameter() {
        return false;
    }

    @Override
    public String getBindingTypes() {
        return null;
    }

    protected Object getValue(Object parameter) throws Exception {
        if (parameter != null && parameter instanceof ExpressionParameter) {
            return ((ExpressionParameter)parameter).eval();
        }
        return parameter;
    }

    protected String getExpression(Object parameter) throws Exception {
        if (parameter != null && parameter instanceof ExpressionParameter) {
            return ((ExpressionParameter)parameter).getExpression();
        }
        return (String)parameter;
    }

    public boolean executeDynamicBoolean(String expression, ScriptContext context) throws ScriptException {
        Object result = this.getScriptEngine().execute(expression, context);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            String newExpression = (String)result;
            newExpression = this.convertExpression(newExpression);
            return (Boolean)this.getScriptEngine().execute(newExpression, context);
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.unrecognized.class", result.getClass().getName()));
    }

    public <T> T executeDynamicObject(String expression, ScriptContext context) throws ScriptException {
        Object result = this.getScriptEngine().execute(expression, context);
        if (result instanceof String) {
            String newExpression = (String)result;
            newExpression = this.convertExpression(newExpression);
            return (T)this.getScriptEngine().execute(newExpression, context);
        }
        return (T)result;
    }

    protected String convertExpression(String expression) {
        if (!expression.startsWith("return")) {
            expression = "return " + expression;
        }
        if (!expression.endsWith(";")) {
            expression = expression + ";";
        }
        return expression;
    }

    protected boolean checkParameters(Object[] parameters, int num) {
        if (parameters != null && parameters.length == num) {
            for (Object parameter : parameters) {
                if (parameter != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<FunctionConfig> getFunctionConfigs() {
        ArrayList<FunctionConfig> configs = new ArrayList<FunctionConfig>();
        String names = this.getNames();
        if (names != null) {
            String[] ss;
            for (String name : ss = names.split(",")) {
                if (StringUtil.isEmpty((String)name)) continue;
                configs.add(new ScriptFunctionConfig(name));
            }
        }
        return configs;
    }
}

