/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function;

import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.impl.DefaultScriptContext;
import org.tinygroup.tinyscript.interpret.ClassInstanceUtil;
import org.tinygroup.tinyscript.interpret.LambdaFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.anonymous.SingleMethodProcessor;

public abstract class AbstractSortFunction
extends AbstractScriptFunction {
    private static final Pattern ORDER_SIMPLE = Pattern.compile("\\s*(asc|desc)\\s*", 2);
    private static final String SPACE = "\\s*";
    private static final String FIELD = ".+";
    private static final String ORDER = "(asc|desc)?";
    private static final Pattern ORDER_FIELD = Pattern.compile("\\s*.+\\s*(asc|desc)?(\\s*,.+\\s*(asc|desc)?)*", 2);
    private Comparator<Object> asc = new SimpleTypeComparator<Object>(true);
    private Comparator<Object> desc = new SimpleTypeComparator<Object>(false);
    protected static final String DEFAULT_CONTEXT_NAME = "_tiny_list_ele";

    @Override
    public String getNames() {
        return "sort";
    }

    @Override
    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        if (parameters == null || parameters.length == 0) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.empty", this.getNames()));
        }
        if (this.checkParameters(parameters, 1)) {
            return this.sort(segment, context, parameters[0], "asc");
        }
        if (this.checkParameters(parameters, 2)) {
            try {
                if (parameters[1] instanceof String) {
                    return this.sort(segment, context, parameters[0], (String)parameters[1]);
                }
                if (parameters[1] instanceof LambdaFunction) {
                    LambdaFunction lambdaFunction = (LambdaFunction)parameters[1];
                    SingleMethodProcessor processor = ClassInstanceUtil.findSingleMethodProcessor(Comparator.class);
                    Comparator c = (Comparator)processor.build(lambdaFunction, context);
                    return this.sortByLambda(parameters[0], c);
                }
            }
            catch (Exception e) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.run.error", this.getNames()), e);
            }
        }
        throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.error", this.getNames()));
    }

    protected boolean matchSimpleRule(String rule) {
        return ORDER_SIMPLE.matcher(rule).matches();
    }

    protected boolean matchFieldRule(String rule) {
        return ORDER_FIELD.matcher(rule).matches();
    }

    protected abstract Object sort(ScriptSegment var1, ScriptContext var2, Object var3, String var4) throws ScriptException;

    public Comparator getComparator(String rule, ScriptSegment segment, Object source) throws Exception {
        if (this.matchSimpleRule(rule)) {
            String runRule = rule.toLowerCase();
            if (runRule.indexOf("desc") > -1) {
                return this.desc;
            }
            return this.asc;
        }
        return this.createComparator(rule, segment, source);
    }

    protected abstract Object sortByLambda(Object var1, Comparator var2) throws Exception;

    protected abstract Comparator createComparator(String var1, ScriptSegment var2, Object var3) throws Exception;

    public class FieldSortComparator<Object>
    implements Comparator<Object> {
        private List<FieldSortRule> fieldSortRuleList;
        private ScriptContext context = new DefaultScriptContext();

        public List<FieldSortRule> getFieldSortRuleList() {
            return this.fieldSortRuleList;
        }

        public void setFieldSortRuleList(List<FieldSortRule> fieldSortRuleList) {
            this.fieldSortRuleList = fieldSortRuleList;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int compareValue = 0;
            try {
                for (FieldSortRule rule : this.fieldSortRuleList) {
                    Object p1 = this.eval(rule, o1);
                    Object p2 = this.eval(rule, o2);
                    compareValue = rule.isAsc() ? this.compareObject(p1, p2) : this.compareObject(p2, p1);
                    if (compareValue == 0) continue;
                    return compareValue;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(ResourceBundleUtil.getDefaultMessage("function.run.error", AbstractSortFunction.this.getNames()), e);
            }
            return compareValue;
        }

        private Object eval(FieldSortRule rule, Object obj) {
            this.context.put(rule.getContextName(), obj);
            try {
                return (Object)AbstractSortFunction.this.getScriptEngine().execute(rule.getSegment(), this.context);
            }
            catch (ScriptException e) {
                throw new RuntimeException(ResourceBundleUtil.getDefaultMessage("function.scirpt.error", AbstractSortFunction.this.getNames(), rule.getSegment()), e);
            }
        }

        protected int compareObject(Object p1, Object p2) {
            if (p1 instanceof Comparable && p2 instanceof Comparable) {
                Comparable c1 = (Comparable)p1;
                Comparable c2 = (Comparable)p2;
                return c1.compareTo(c2);
            }
            String s1 = p1.toString();
            String s2 = p2.toString();
            return s1.compareTo(s2);
        }
    }

    public class FieldSortRule {
        private boolean asc;
        private String contextName;
        private String segment;
        private int index;

        public boolean isAsc() {
            return this.asc;
        }

        public void setAsc(boolean asc) {
            this.asc = asc;
        }

        public String getContextName() {
            return this.contextName;
        }

        public void setContextName(String contextName) {
            this.contextName = contextName;
        }

        public String getSegment() {
            return this.segment;
        }

        public void setSegment(String segment) {
            this.segment = segment;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    class SimpleTypeComparator<Object>
    implements Comparator<Object> {
        private boolean asc;

        public SimpleTypeComparator(boolean ascTag) {
            this.asc = ascTag;
        }

        @Override
        public int compare(Object o2, Object o1) {
            if (this.asc) {
                return this.compareObject(o2, o1);
            }
            return this.compareObject(o1, o2);
        }

        protected int compareObject(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareTo(s2);
        }
    }
}

