/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.naming.NamingString;
import org.tinygroup.tinyscript.naming.NamingStringUtil;

public abstract class AbstractToBeanFunction
extends AbstractScriptFunction {
    @Override
    public String getNames() {
        return "toBean";
    }

    protected Object toBean(Map<String, Object> map, String className) throws Exception {
        try {
            Class<?> clazz = Class.forName(className);
            return this.toBean(map, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.tobean.noclass", className));
        }
    }

    protected Object toBean(Map<String, Object> map, Class<?> clazz) throws Exception {
        Object bean = null;
        try {
            bean = clazz.newInstance();
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.tobean.instance", clazz.getName()));
        }
        HashMap<NamingString, String> linkMap = new HashMap<NamingString, String>();
        for (String key : map.keySet()) {
            NamingString ns = NamingStringUtil.parse(key);
            linkMap.put(ns, key);
        }
        for (Field classField : clazz.getDeclaredFields()) {
            NamingString ns = NamingStringUtil.parse(classField.getName());
            if (!linkMap.containsKey(ns)) continue;
            String key = (String)linkMap.get(ns);
            try {
                BeanUtils.setProperty(bean, (String)classField.getName(), (Object)map.get(key));
            }
            catch (Exception e) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.tobean.setvalue", clazz.getName(), classField.getName(), map.get(key)), e);
            }
        }
        return bean;
    }
}

