/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.date;

import java.util.Calendar;
import java.util.Date;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.expression.ExpressionUtil;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.function.date.DateEnum;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class DateAddFunction
extends AbstractScriptFunction {
    @Override
    public String getNames() {
        return "dateAdd";
    }

    @Override
    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        try {
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.empty", this.getNames()));
            }
            if (this.checkParameters(parameters, 3)) {
                DateEnum datePart = DateEnum.valueOf(((String)parameters[0]).toUpperCase());
                Integer interval = ExpressionUtil.convertInteger(parameters[1]);
                Date date = (Date)parameters[2];
                Calendar newDate = Calendar.getInstance();
                newDate.setTime(date);
                newDate.set(datePart.getCalendarId(), newDate.get(datePart.getCalendarId()) + interval);
                return new Date(newDate.getTimeInMillis());
            }
            throw new NotMatchException(ResourceBundleUtil.getDefaultMessage("function.parameter.error", this.getNames()));
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.run.error", this.getNames()), e);
        }
    }
}

