/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyscript.function.date;

import java.util.Calendar;
import java.util.Date;
import org.tinygroup.tinyscript.ScriptContext;
import org.tinygroup.tinyscript.ScriptException;
import org.tinygroup.tinyscript.ScriptSegment;
import org.tinygroup.tinyscript.function.AbstractScriptFunction;
import org.tinygroup.tinyscript.function.date.DateEnum;
import org.tinygroup.tinyscript.function.date.DateUtil;
import org.tinygroup.tinyscript.interpret.ResourceBundleUtil;
import org.tinygroup.tinyscript.interpret.exception.NotMatchException;

public class DateDifferentFunction
extends AbstractScriptFunction {
    @Override
    public String getNames() {
        return "dateDiff";
    }

    @Override
    public Object execute(ScriptSegment segment, ScriptContext context, Object ... parameters) throws ScriptException {
        DateEnum datePart = null;
        Date date1 = null;
        Date date2 = null;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        String startWeekDay = null;
        try {
            if (parameters == null || parameters.length == 0) {
                throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.parameter.empty", this.getNames()));
            }
            if (this.checkParameters(parameters, 3)) {
                datePart = DateEnum.valueOf(((String)parameters[0]).toUpperCase());
                date1 = (Date)parameters[1];
                date2 = (Date)parameters[2];
            } else if (this.checkParameters(parameters, 4)) {
                datePart = DateEnum.valueOf(((String)parameters[0]).toUpperCase());
                date1 = (Date)parameters[1];
                date2 = (Date)parameters[2];
                startWeekDay = (String)parameters[3];
            } else {
                throw new NotMatchException(ResourceBundleUtil.getDefaultMessage("function.parameter.error", this.getNames()));
            }
            cal1.setTime(date1);
            cal2.setTime(date2);
            switch (datePart) {
                case YEAR: 
                case MONTH: 
                case WEEKDAY: {
                    return cal2.get(datePart.getCalendarId()) - cal2.get(datePart.getCalendarId());
                }
                case WEEK: {
                    return DateUtil.countWeekDiff(cal1, cal2, startWeekDay);
                }
                case DAY: {
                    return (date1.getTime() - date2.getTime()) / 86400000L;
                }
                case HOUR: {
                    return (date1.getTime() - date2.getTime()) / 3600000L;
                }
                case MINUTE: {
                    return (date1.getTime() - date2.getTime()) / 60000L;
                }
                case SECOND: {
                    return (date1.getTime() - date2.getTime()) / 1000L;
                }
            }
            return null;
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(ResourceBundleUtil.getDefaultMessage("function.run.error", this.getNames()), e);
        }
    }
}

